/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Route;
import java.io.Serializable;

public class MetricsFilter
implements Route.Filter {
    @NonNull
    public Route.Handler apply(@NonNull Route.Handler next) {
        return (Route.Handler & Serializable)ctx -> {
            MetricRegistry registry = (MetricRegistry)ctx.require(MetricRegistry.class);
            Counter counter = registry.counter("request.actives");
            Timer.Context timer = registry.timer("request").time();
            counter.inc();
            ctx.onComplete(context -> {
                timer.stop();
                counter.dec();
                registry.meter("responses." + context.getResponseCode().value()).mark();
            });
            return next.apply(ctx);
        };
    }
}

