/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.maven;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.Maven;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

public abstract class BaseMojo
extends AbstractMojo {
    private static final Set<String> SCOPES = Set.of("compile", "system", "provided", "runtime", "test");
    protected static final String APP_CLASS = "application.class";
    @Parameter(defaultValue="${application.class}")
    private String mainClass;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Component
    private Maven maven;
    @Component
    private ProjectDependenciesResolver dependenciesResolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            List<MavenProject> projects = this.getProjects();
            if (this.mainClass == null) {
                this.mainClass = projects.stream().filter(it -> it.getProperties().containsKey(APP_CLASS)).findFirst().map(it -> it.getProperties().getProperty(APP_CLASS)).orElseThrow(() -> new MojoExecutionException("Application class not found. Did you forget to set `application.class`?"));
            }
            this.getLog().debug((CharSequence)("Found `application.class`: " + this.mainClass));
            this.doExecute(projects, this.mainClass);
        }
        catch (MojoExecutionException | MojoFailureException x) {
            throw x;
        }
        catch (Throwable x) {
            throw new MojoFailureException("execution of " + this.mojoName() + " resulted in exception", x);
        }
    }

    protected String mojoName() {
        return ((Object)((Object)this)).getClass().getSimpleName().replace("Mojo", "").toLowerCase();
    }

    protected abstract void doExecute(@NonNull List<MavenProject> var1, @NonNull String var2) throws Throwable;

    protected List<MavenProject> getProjects() {
        return this.session.getAllProjects().stream().filter(it -> !it.getPackaging().equals("pom")).collect(Collectors.toList());
    }

    public Maven getMaven() {
        return this.maven;
    }

    public void setMaven(Maven maven) {
        this.maven = maven;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public ProjectDependenciesResolver getDependenciesResolver() {
        return this.dependenciesResolver;
    }

    public void setDependenciesResolver(ProjectDependenciesResolver dependenciesResolver) {
        this.dependenciesResolver = dependenciesResolver;
    }

    protected Set<Path> jars(MavenProject project, boolean useTestScope) throws DependencyResolutionException {
        Set artifacts = project.getArtifacts();
        HashSet<String> scopes = new HashSet<String>(SCOPES);
        if (!useTestScope) {
            scopes.remove("test");
        }
        if (artifacts.isEmpty()) {
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest();
            request.setMavenProject(project);
            request.setRepositorySession(this.session.getRepositorySession());
            DependencyResolutionResult result = this.dependenciesResolver.resolve((DependencyResolutionRequest)request);
            return result.getDependencies().stream().filter(it -> !it.isOptional()).filter(it -> scopes.contains(it.getScope())).map(Dependency::getArtifact).filter(Objects::nonNull).filter(it -> it.getExtension().equals("jar")).map(Artifact::getFile).filter(Objects::nonNull).map(File::toPath).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return artifacts.stream().filter(it -> scopes.contains(it.getScope())).map(org.apache.maven.artifact.Artifact::getFile).filter(Objects::nonNull).filter(it -> it.toString().endsWith(".jar")).map(File::toPath).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected Set<Path> resources(MavenProject project, boolean useTestScope) {
        ArrayList resourceList = new ArrayList();
        if (useTestScope) {
            resourceList.addAll(project.getTestResources());
        }
        resourceList.addAll(project.getResources());
        List paths = resourceList.stream().map(FileSet::getDirectory).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        Path conf = project.getBasedir().toPath().resolve("conf");
        paths.add(conf);
        return paths.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected Set<Path> bin(MavenProject project, boolean useTestScope) {
        Path outputDir = Paths.get(project.getBuild().getOutputDirectory(), new String[0]);
        if (useTestScope) {
            return Set.of(Paths.get(project.getBuild().getTestOutputDirectory(), new String[0]), outputDir);
        }
        return Collections.singleton(outputDir);
    }

    protected ClassLoader createClassLoader(List<MavenProject> projects) throws MalformedURLException, DependencyResolutionException {
        return BaseMojo.toClassLoader(this.classpath(projects), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private List<URL> classpath(List<MavenProject> projects) throws MalformedURLException, DependencyResolutionException {
        ArrayList<URL> classpath = new ArrayList<URL>();
        for (MavenProject project : projects) {
            Set<Path> cp = this.classpath(project);
            for (Path path : cp) {
                classpath.add(path.toUri().toURL());
            }
        }
        return classpath.stream().distinct().collect(Collectors.toList());
    }

    private Set<Path> classpath(MavenProject project) throws DependencyResolutionException {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>(this.resources(project, false));
        paths.addAll(this.bin(project, false));
        paths.addAll(this.jars(project, false));
        return paths;
    }

    private static URLClassLoader toClassLoader(final List<URL> cp, ClassLoader parent) {
        return new URLClassLoader(cp.toArray(new URL[cp.size()]), parent){

            public String toString() {
                return cp.toString();
            }
        };
    }
}

