/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.maven;

import io.jooby.maven.BaseMojo;
import io.jooby.openapi.OpenAPIGenerator;
import io.swagger.v3.oas.models.OpenAPI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="openapi", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, aggregator=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class OpenAPIMojo
extends BaseMojo {
    @Parameter(property="openAPI.includes")
    private String includes;
    @Parameter(property="openAPI.excludes")
    private String excludes;

    @Override
    protected void doExecute(@Nonnull List<MavenProject> projects, @Nonnull String mainClass) throws Exception {
        ClassLoader classLoader = this.createClassLoader(projects);
        this.getLog().info((CharSequence)("Generating OpenAPI: " + mainClass));
        this.getLog().debug((CharSequence)("Using classloader: " + classLoader));
        String[] names = mainClass.split("\\.");
        Path dir = Stream.of(names).reduce(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]), Path::resolve, Path::resolve).getParent();
        OpenAPIGenerator tool = new OpenAPIGenerator();
        tool.setClassLoader(classLoader);
        tool.setOutputDir(dir);
        this.trim(this.includes).ifPresent(arg_0 -> ((OpenAPIGenerator)tool).setIncludes(arg_0));
        this.trim(this.excludes).ifPresent(arg_0 -> ((OpenAPIGenerator)tool).setExcludes(arg_0));
        OpenAPI result = tool.generate(mainClass);
        for (OpenAPIGenerator.Format format : OpenAPIGenerator.Format.values()) {
            Path output = tool.export(result, format);
            this.getLog().info((CharSequence)("  writing: " + output));
        }
    }

    private Optional<String> trim(String value) {
        if (value == null || value.trim().length() == 0) {
            return Optional.empty();
        }
        return Optional.of(value.trim());
    }

    @Nullable
    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(@Nullable String includes) {
        this.includes = includes;
    }

    @Nullable
    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(@Nullable String excludes) {
        this.excludes = excludes;
    }
}

