/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.maven;

import edu.emory.mathcs.backport.java.util.Collections;
import io.jooby.maven.BaseMojo;
import io.jooby.run.JoobyRun;
import io.jooby.run.JoobyRunOptions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.maven.Maven;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="run", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, aggregator=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class RunMojo
extends BaseMojo {
    @Parameter(property="jooby.restartExtensions")
    private List<String> restartExtensions;
    @Parameter(property="jooby.compileExtensions")
    private List<String> compileExtensions;
    @Parameter(property="jooby.port")
    private Integer port;
    @Parameter(property="jooby.waitTimeBeforeRestart")
    private Long waitTimeBeforeRestart;

    @Override
    protected void doExecute(List<MavenProject> projects, String mainClass) throws Throwable {
        Maven maven = this.getMaven();
        JoobyRunOptions options = this.createOptions(mainClass);
        this.getLog().debug((CharSequence)("jooby options: " + options));
        JoobyRun joobyRun = new JoobyRun(options);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((JoobyRun)joobyRun).shutdown()));
        BiConsumer<String, Path> onFileChanged = (event, path) -> {
            if (options.isCompileExtension(path)) {
                MavenExecutionResult result = maven.execute(this.mavenRequest("process-classes"));
                if (result.hasExceptions()) {
                    this.getLog().debug((CharSequence)("Compilation error found: " + path));
                } else {
                    this.getLog().debug((CharSequence)("Restarting application on file change: " + path));
                    joobyRun.restart();
                }
            } else if (options.isRestartExtension(path)) {
                this.getLog().debug((CharSequence)("Restarting application on file change: " + path));
                joobyRun.restart();
            } else {
                this.getLog().debug((CharSequence)("Ignoring file change: " + path));
            }
        };
        for (MavenProject project : projects) {
            this.getLog().debug((CharSequence)("Adding project: " + project.getArtifactId()));
            this.resources(project).forEach(file -> joobyRun.addResource(file, onFileChanged));
            this.bin(project).forEach(arg_0 -> ((JoobyRun)joobyRun).addResource(arg_0));
            Set<Path> src = this.sourceDirectories(project);
            if (src.isEmpty()) {
                this.getLog().debug((CharSequence)"Compiler is off in favor of Eclipse compiler.");
                this.bin(project).forEach(path -> joobyRun.addResource(path, onFileChanged));
            } else {
                src.forEach(path -> joobyRun.addResource(path, onFileChanged));
            }
            this.jars(project).forEach(arg_0 -> ((JoobyRun)joobyRun).addResource(arg_0));
        }
        joobyRun.start();
    }

    private JoobyRunOptions createOptions(String mainClass) {
        JoobyRunOptions options = new JoobyRunOptions();
        options.setMainClass(mainClass);
        if (this.compileExtensions != null) {
            options.setCompileExtensions(this.compileExtensions);
        }
        options.setPort(this.port);
        options.setWaitTimeBeforeRestart(this.waitTimeBeforeRestart);
        options.setProjectName(this.session.getCurrentProject().getArtifactId());
        if (this.restartExtensions != null) {
            options.setRestartExtensions(this.restartExtensions);
        }
        return options;
    }

    public List<String> getCompileExtensions() {
        return this.compileExtensions;
    }

    public void setCompileExtensions(List<String> compileExtensions) {
        this.compileExtensions = compileExtensions;
    }

    public List<String> getRestartExtensions() {
        return this.restartExtensions;
    }

    public void setRestartExtensions(List<String> restartExtensions) {
        this.restartExtensions = restartExtensions;
    }

    private MavenExecutionRequest mavenRequest(String goal) {
        return DefaultMavenExecutionRequest.copy((MavenExecutionRequest)this.session.getRequest()).setGoals(Collections.singletonList((Object)goal));
    }

    private Set<Path> sourceDirectories(MavenProject project) {
        Path eclipse = project.getBasedir().toPath().resolve(".classpath");
        if (Files.exists(eclipse, new LinkOption[0])) {
            return Collections.emptySet();
        }
        return Collections.singleton((Object)Paths.get(project.getBuild().getSourceDirectory(), new String[0]));
    }

    @Override
    protected String mojoName() {
        return "run";
    }

    static {
        System.setProperty("jooby.useShutdownHook", "false");
    }
}

