/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.maven;

import edu.emory.mathcs.backport.java.util.Collections;
import io.jooby.run.HotSwap;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.maven.Maven;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;

@Mojo(name="run", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST)
public class RunMojo
extends AbstractMojo {
    private static final String APP_CLASS = "application.class";
    @Parameter(defaultValue="${application.class}")
    private String mainClass;
    @Parameter(defaultValue="${application.mode}")
    private String executionMode = "DEFAULT";
    @Parameter(defaultValue="conf,properties,class")
    private List<String> restartExtensions;
    @Parameter(defaultValue="java,kt")
    private List<String> compileExtensions;
    @Parameter(defaultValue="${server.port}")
    private int port = 8080;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component
    private ProjectDependenciesResolver dependenciesResolver;
    @Component
    private Maven maven;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            List<MavenProject> projects = this.projects();
            if (this.mainClass == null) {
                this.mainClass = projects.stream().filter(it -> it.getProperties().containsKey(APP_CLASS)).findFirst().map(it -> it.getProperties().getProperty(APP_CLASS)).orElseThrow(() -> new MojoExecutionException("Application class not found. Did you forget to set `application.class`?"));
            }
            this.getLog().debug((CharSequence)("Found `application.class`: " + this.mainClass));
            HotSwap hotSwap = new HotSwap(this.session.getCurrentProject().getArtifactId(), this.mainClass, this.executionMode);
            hotSwap.setPort(this.port);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((HotSwap)hotSwap).shutdown()));
            BiConsumer<String, Path> onFileChanged = (event, path) -> {
                if (this.isCompileExtension((Path)path)) {
                    MavenExecutionResult result = this.maven.execute(this.mavenRequest("process-classes"));
                    if (result.hasExceptions()) {
                        this.getLog().debug((CharSequence)("Compilation error found: " + path));
                    } else {
                        this.getLog().debug((CharSequence)("Restarting application on file change: " + path));
                        hotSwap.restart();
                    }
                } else if (this.isRestartExtension((Path)path)) {
                    this.getLog().debug((CharSequence)("Restarting application on file change: " + path));
                    hotSwap.restart();
                } else {
                    this.getLog().debug((CharSequence)("Ignoring file change: " + path));
                }
            };
            for (MavenProject project : projects) {
                this.getLog().debug((CharSequence)("Adding project: " + project.getArtifactId()));
                List resourceList = project.getResources();
                resourceList.stream().map(FileSet::getDirectory).map(x$0 -> Paths.get(x$0, new String[0])).forEach(file -> hotSwap.addResource(file, onFileChanged));
                Path conf = project.getBasedir().toPath().resolve("conf");
                hotSwap.addResource(conf, onFileChanged);
                hotSwap.addResource(Paths.get(project.getBuild().getOutputDirectory(), new String[0]));
                Set<Path> src = this.sourceDirectories(project);
                if (src.isEmpty()) {
                    this.getLog().debug((CharSequence)"Compiler is off in favor of Eclipse compiler.");
                    this.binDirectories(project).forEach(path -> hotSwap.addResource(path, onFileChanged));
                } else {
                    src.forEach(path -> hotSwap.addResource(path, onFileChanged));
                }
                this.artifacts(project).forEach(arg_0 -> ((HotSwap)hotSwap).addResource(arg_0));
            }
            hotSwap.start();
        }
        catch (MojoExecutionException | MojoFailureException x) {
            throw x;
        }
        catch (Exception x) {
            throw new MojoFailureException("jooby-run resulted in exception", (Throwable)x);
        }
    }

    public List<String> getCompileExtensions() {
        return this.compileExtensions;
    }

    public void setCompileExtensions(List<String> compileExtensions) {
        this.compileExtensions = compileExtensions;
    }

    public List<String> getRestartExtensions() {
        return this.restartExtensions;
    }

    public void setRestartExtensions(List<String> restartExtensions) {
        this.restartExtensions = restartExtensions;
    }

    public Maven getMaven() {
        return this.maven;
    }

    public void setMaven(Maven maven) {
        this.maven = maven;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public ProjectDependenciesResolver getDependenciesResolver() {
        return this.dependenciesResolver;
    }

    public void setDependenciesResolver(ProjectDependenciesResolver dependenciesResolver) {
        this.dependenciesResolver = dependenciesResolver;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    private boolean isCompileExtension(Path path) {
        return this.containsExtension(this.compileExtensions, path);
    }

    private boolean isRestartExtension(Path path) {
        return this.containsExtension(this.restartExtensions, path);
    }

    private boolean containsExtension(List<String> extensions, Path path) {
        String filename = path.getFileName().toString();
        return extensions.stream().anyMatch(ext -> filename.endsWith("." + ext));
    }

    private Set<Path> artifacts(MavenProject project) throws DependencyResolutionException {
        Set artifacts = project.getArtifacts();
        if (artifacts.isEmpty()) {
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest();
            request.setMavenProject(project);
            request.setRepositorySession(this.session.getRepositorySession());
            DependencyResolutionResult result = this.dependenciesResolver.resolve((DependencyResolutionRequest)request);
            return result.getDependencies().stream().filter(it -> !it.isOptional()).map(Dependency::getArtifact).filter(it -> it.getExtension().equals("jar")).map(Artifact::getFile).map(File::toPath).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return artifacts.stream().map(org.apache.maven.artifact.Artifact::getFile).filter(it -> it.toString().endsWith(".jar")).map(File::toPath).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<MavenProject> projects() {
        return this.session.getAllProjects().stream().filter(it -> !it.getPackaging().equals("pom")).collect(Collectors.toList());
    }

    private MavenExecutionRequest mavenRequest(String goal) {
        return DefaultMavenExecutionRequest.copy((MavenExecutionRequest)this.session.getRequest()).setGoals(Collections.singletonList((Object)goal));
    }

    private Set<Path> sourceDirectories(MavenProject project) {
        Path eclipse = project.getBasedir().toPath().resolve(".classpath");
        if (Files.exists(eclipse, new LinkOption[0])) {
            return Collections.emptySet();
        }
        return Collections.singleton((Object)Paths.get(project.getBuild().getSourceDirectory(), new String[0]));
    }

    private Set<Path> binDirectories(MavenProject project) {
        return Collections.singleton((Object)Paths.get(project.getBuild().getOutputDirectory(), new String[0]));
    }

    static {
        System.setProperty("jooby.useShutdownHook", "false");
    }
}

