/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.jwt;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.SessionToken;
import io.jooby.SneakyThrows;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;

public class JwtSessionStore
implements SessionStore {
    private final SessionStore store;

    public JwtSessionStore(@NonNull String key) {
        this(key, SessionToken.signedCookie((Cookie)SessionToken.SID));
    }

    public JwtSessionStore(@NonNull String key, @NonNull SessionToken token) {
        this(Keys.hmacShaKeyFor((byte[])key.getBytes(StandardCharsets.UTF_8)), token);
    }

    public JwtSessionStore(@NonNull SecretKey key, @NonNull SessionToken token) {
        this.store = SessionStore.signed((SessionToken)token, JwtSessionStore.decoder(key), JwtSessionStore.encoder(key));
    }

    @NonNull
    public Session newSession(@NonNull Context ctx) {
        return this.store.newSession(ctx);
    }

    @Nullable
    public Session findSession(@NonNull Context ctx) {
        return this.store.findSession(ctx);
    }

    public void deleteSession(@NonNull Context ctx, @NonNull Session session) {
        this.store.deleteSession(ctx, session);
    }

    public void touchSession(@NonNull Context ctx, @NonNull Session session) {
        this.store.touchSession(ctx, session);
    }

    public void saveSession(@NonNull Context ctx, @NonNull Session session) {
        this.store.saveSession(ctx, session);
    }

    public void renewSessionId(@NonNull Context ctx, @NonNull Session session) {
        this.store.renewSessionId(ctx, session);
    }

    static SneakyThrows.Function<String, Map<String, String>> decoder(SecretKey key) {
        return value -> {
            try {
                Jws claims = Jwts.parser().verifyWith(key).build().parseSignedClaims((CharSequence)value);
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (Map.Entry entry : ((Claims)claims.getPayload()).entrySet()) {
                    attributes.put((String)entry.getKey(), entry.getValue().toString());
                }
                return attributes;
            }
            catch (JwtException x) {
                return null;
            }
        };
    }

    static SneakyThrows.Function<Map<String, String>, String> encoder(Key key) {
        return attributes -> {
            JwtBuilder builder = Jwts.builder().signWith(key);
            for (Map.Entry entry : attributes.entrySet()) {
                builder.claim((String)entry.getKey(), entry.getValue());
            }
            return builder.compact();
        };
    }
}

