/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import io.jooby.Http2Configurer;
import io.jooby.internal.netty.Http2Extension;
import io.jooby.internal.netty.Http2OrHttp11Handler;
import io.jooby.internal.netty.Http2PrefaceOrHttpHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;

public class NettyHttp2Configurer
implements Http2Configurer<Http2Extension, ChannelInboundHandler> {
    public boolean support(Class type) {
        return type == Http2Extension.class;
    }

    public ChannelInboundHandler configure(Http2Extension extension) {
        if (extension.isSecure()) {
            return new Http2OrHttp11Handler(arg_0 -> ((Http2Extension)extension).http11(arg_0), pipeline -> extension.http2(pipeline, settings -> this.newHttp2Handler(settings.getMaxRequestSize(), HttpScheme.HTTPS)));
        }
        return new Http2PrefaceOrHttpHandler(pipeline -> extension.http11Upgrade(pipeline, settings -> new Http2ServerUpgradeCodec(this.newHttp2Handler(settings.getMaxRequestSize(), HttpScheme.HTTP))), pipeline -> extension.http2c(pipeline, settings -> this.newHttp2Handler(settings.getMaxRequestSize(), HttpScheme.HTTP)));
    }

    private Http2ConnectionHandler newHttp2Handler(int maxRequestSize, HttpScheme scheme) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        InboundHttp2ToHttpAdapter listener = new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).propagateSettings(false).validateHttpHeaders(true).maxContentLength(maxRequestSize).build();
        return new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)listener).frameLogger(new Http2FrameLogger(LogLevel.DEBUG)).connection((Http2Connection)connection).httpScheme(scheme).build();
    }
}

