/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.hibernate;

import io.jooby.SneakyThrows;
import io.jooby.hibernate.UnitOfWork;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitOfWorkImpl
implements UnitOfWork {
    private final Session session;
    private final Logger logger = LoggerFactory.getLogger(UnitOfWorkImpl.class);

    public UnitOfWorkImpl(Session session) {
        this.session = Objects.requireNonNull(session);
        this.bind(session);
        session.setHibernateFlushMode(FlushMode.AUTO);
    }

    private void bind(Session session) {
        this.logger.debug("session bound: {}", (Object)this.oid(session));
        ManagedSessionContext.bind((Session)session);
    }

    private void unbind(SessionFactory sessionFactory) {
        Session session = ManagedSessionContext.unbind((SessionFactory)sessionFactory);
        this.logger.debug("session unbound: {}", (Object)this.oid(session));
    }

    private String oid(Object value) {
        return Integer.toHexString(System.identityHashCode(value));
    }

    private void begin() {
        Transaction tx = this.session.getTransaction();
        this.logger.debug("begin transaction: {}(trx@{})", (Object)this.oid(this.session), (Object)this.oid(tx));
        tx.begin();
    }

    private void commit() {
        this.logger.debug("flushing session: {}", (Object)this.oid(this.session));
        this.session.flush();
        Transaction tx = this.session.getTransaction();
        this.logger.debug("commit transaction: {}(trx@{})", (Object)this.oid(this.session), (Object)this.oid(tx));
        tx.commit();
    }

    private void rollback() {
        Transaction tx = this.session.getTransaction();
        this.logger.debug("rollback transaction: {}(trx@{})", (Object)this.oid(this.session), (Object)this.oid(tx));
        tx.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T apply(SneakyThrows.Function2<EntityManager, UnitOfWork.TransactionHandler, T> callback) {
        if (!this.session.isOpen()) {
            throw new IllegalStateException("Session is not open.");
        }
        try {
            this.begin();
            Object result = callback.apply((Object)this.session, (Object)new UnitOfWork.TransactionHandler(){

                @Override
                public void commit() {
                    UnitOfWorkImpl.this.commit();
                    UnitOfWorkImpl.this.begin();
                }

                @Override
                public void rollback() {
                    UnitOfWorkImpl.this.rollback();
                    UnitOfWorkImpl.this.begin();
                }
            });
            this.commit();
            Object object = result;
            return (T)object;
        }
        catch (Throwable t) {
            try {
                this.rollback();
            }
            catch (Throwable th) {
                this.logger.error("failed to rollback transaction: {}", (Object)this.oid(this.session), (Object)th);
            }
            throw SneakyThrows.propagate((Throwable)t);
        }
        finally {
            try {
                this.session.close();
                this.logger.debug("session closed: {}", (Object)this.oid(this.session));
            }
            catch (HibernateException e) {
                this.logger.error("session.close() resulted in exception: {}", (Object)this.oid(this.session), (Object)e);
            }
            finally {
                this.unbind(this.session.getSessionFactory());
            }
        }
    }
}

