/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.hibernate;

import io.jooby.Route;
import io.jooby.ServiceKey;
import io.jooby.hibernate.SessionProvider;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionRequest
implements Route.Decorator {
    private static final Logger log = LoggerFactory.getLogger(SessionRequest.class);
    private final ServiceKey<SessionFactory> sessionFactoryKey;
    private final ServiceKey<SessionProvider> sessionProviderKey;

    public SessionRequest(@Nonnull String name) {
        this((ServiceKey<SessionFactory>)ServiceKey.key(SessionFactory.class, (String)name));
    }

    public SessionRequest() {
        this((ServiceKey<SessionFactory>)ServiceKey.key(SessionFactory.class));
    }

    private SessionRequest(ServiceKey<SessionFactory> sessionFactoryKey) {
        this.sessionFactoryKey = sessionFactoryKey;
        this.sessionProviderKey = ServiceKey.key(SessionProvider.class, (String)sessionFactoryKey.getName());
    }

    @Nonnull
    public Route.Handler apply(@Nonnull Route.Handler next) {
        return (Route.Handler & Serializable)ctx -> {
            SessionFactory sessionFactory = (SessionFactory)ctx.require(this.sessionFactoryKey);
            SessionProvider sessionProvider = (SessionProvider)ctx.require(this.sessionProviderKey);
            Session session = sessionProvider.newSession(sessionFactory.withOptions());
            try {
                ManagedSessionContext.bind((Session)session);
                Object result = next.apply(ctx);
                Transaction transaction = session.getTransaction();
                if (transaction.getStatus() == TransactionStatus.ACTIVE) {
                    log.error("Transaction state is still active (expected to be committed, or rolled back) after route pipeline completed, rolling back.");
                    transaction.rollback();
                }
                Object object = result;
                return object;
            }
            finally {
                ManagedSessionContext.unbind((SessionFactory)sessionFactory);
                if (session != null) {
                    session.close();
                }
            }
        };
    }

    @Nonnull
    public ServiceKey<SessionFactory> getSessionFactoryKey() {
        return this.sessionFactoryKey;
    }
}

