/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.hibernate;

import io.jooby.Route;
import io.jooby.ServiceKey;
import io.jooby.SneakyThrows;
import io.jooby.hibernate.SessionRequest;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class TransactionalRequest
implements Route.Decorator {
    private SessionRequest sessionRequest;
    private ServiceKey<SessionFactory> key;

    public TransactionalRequest(@Nonnull String name) {
        this.sessionRequest = new SessionRequest(name);
        this.key = ServiceKey.key(SessionFactory.class, (String)name);
    }

    public TransactionalRequest() {
        this.sessionRequest = new SessionRequest();
        this.key = ServiceKey.key(SessionFactory.class);
    }

    @Nonnull
    public Route.Handler apply(@Nonnull Route.Handler next) {
        return this.sessionRequest.apply((Route.Handler & Serializable)ctx -> {
            SessionFactory sessionFactory = (SessionFactory)ctx.require(this.key);
            Transaction trx = null;
            try {
                Session session = sessionFactory.getCurrentSession();
                trx = session.getTransaction();
                trx.begin();
                Object result = next.apply(ctx);
                if (trx.isActive()) {
                    trx.commit();
                }
                return result;
            }
            catch (Throwable ex) {
                if (trx != null && trx.isActive()) {
                    trx.rollback();
                }
                throw SneakyThrows.propagate((Throwable)ex);
            }
        });
    }
}

