/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.hibernate;

import io.jooby.Route;
import io.jooby.ServiceKey;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionRequest
implements Route.Decorator {
    private static final Logger log = LoggerFactory.getLogger(SessionRequest.class);
    private final ServiceKey<SessionFactory> key;

    public SessionRequest(@Nonnull String name) {
        this.key = ServiceKey.key(SessionFactory.class, (String)name);
    }

    public SessionRequest() {
        this.key = ServiceKey.key(SessionFactory.class);
    }

    @Nonnull
    public Route.Handler apply(@Nonnull Route.Handler next) {
        return (Route.Handler & Serializable)ctx -> {
            SessionFactory sessionFactory = (SessionFactory)ctx.require(this.key);
            try {
                Session session = sessionFactory.openSession();
                ManagedSessionContext.bind((Session)session);
                Object result = next.apply(ctx);
                Transaction transaction = session.getTransaction();
                if (transaction.getStatus() == TransactionStatus.ACTIVE) {
                    log.error("Transaction state is still active (expected to be committed, or rolled back) after route pipeline completed, rolling back.");
                    transaction.rollback();
                }
                Object object = result;
                return object;
            }
            finally {
                Session session = ManagedSessionContext.unbind((SessionFactory)sessionFactory);
                if (session != null) {
                    sessionFactory.close();
                }
            }
        };
    }
}

