/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.hibernate;

import io.jooby.Route;
import io.jooby.ServiceKey;
import io.jooby.SneakyThrows;
import io.jooby.hibernate.SessionProvider;
import io.jooby.hibernate.SessionRequest;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalRequest
implements Route.Decorator {
    private static final Logger log = LoggerFactory.getLogger(SessionRequest.class);
    private final ServiceKey<SessionFactory> sessionFactoryKey;
    private final ServiceKey<SessionProvider> sessionProviderKey;
    private boolean enabledByDefault = true;

    public TransactionalRequest(@Nonnull String name) {
        this((ServiceKey<SessionFactory>)ServiceKey.key(SessionFactory.class, (String)name));
    }

    public TransactionalRequest() {
        this((ServiceKey<SessionFactory>)ServiceKey.key(SessionFactory.class));
    }

    private TransactionalRequest(ServiceKey<SessionFactory> sessionFactoryKey) {
        this.sessionFactoryKey = sessionFactoryKey;
        this.sessionProviderKey = sessionFactoryKey.getName() == null ? ServiceKey.key(SessionProvider.class) : ServiceKey.key(SessionProvider.class, (String)sessionFactoryKey.getName());
    }

    public TransactionalRequest enabledByDefault(boolean enabledByDefault) {
        this.enabledByDefault = enabledByDefault;
        return this;
    }

    @Nonnull
    public Route.Handler apply(@Nonnull Route.Handler next) {
        return (Route.Handler & Serializable)ctx -> {
            if (ctx.getRoute().isTransactional(this.enabledByDefault)) {
                SessionFactory sessionFactory = (SessionFactory)ctx.require(this.sessionFactoryKey);
                SessionProvider sessionProvider = (SessionProvider)ctx.require(this.sessionProviderKey);
                try {
                    try (Session session = sessionProvider.newSession(sessionFactory.withOptions());){
                        Object result;
                        ManagedSessionContext.bind((Session)session);
                        Transaction trx = null;
                        try {
                            trx = session.getTransaction();
                            trx.begin();
                            result = next.apply(ctx);
                            if (trx.isActive()) {
                                trx.commit();
                            }
                        }
                        catch (Throwable ex) {
                            if (trx != null && trx.isActive()) {
                                trx.rollback();
                            }
                            throw SneakyThrows.propagate((Throwable)ex);
                        }
                        this.ensureCompletion(session.getTransaction());
                        Object object = result;
                        return object;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    ManagedSessionContext.unbind((SessionFactory)sessionFactory);
                }
            }
            return next.apply(ctx);
        };
    }

    private void ensureCompletion(Transaction transaction) {
        if (transaction.getStatus() == TransactionStatus.ACTIVE) {
            log.error("Transaction state is still active (expected to be committed, or rolled back) after route pipeline completed, rolling back.");
            transaction.rollback();
        }
    }
}

