/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.hibernate;

import com.typesafe.config.Config;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import io.jooby.hibernate.HibernateConfigurer;
import io.jooby.hibernate.SessionProvider;
import io.jooby.hibernate.UnitOfWork;
import io.jooby.internal.hibernate.ScanEnvImpl;
import io.jooby.internal.hibernate.SessionServiceProvider;
import io.jooby.internal.hibernate.UnitOfWorkProvider;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;

public class HibernateModule
implements Extension {
    private final String name;
    private List<String> packages = Collections.emptyList();
    private List<Class> classes;
    private HibernateConfigurer configurer = new HibernateConfigurer();
    private SessionProvider sessionBuilder = SessionBuilder::openSession;

    public HibernateModule(@Nonnull String name, Class ... classes) {
        this.name = name;
        this.classes = Arrays.asList(classes);
    }

    public HibernateModule(Class ... classes) {
        this("db", classes);
    }

    public HibernateModule(@Nonnull String name, List<Class> classes) {
        this.name = name;
        this.classes = classes;
    }

    @Nonnull
    public HibernateModule scan(String ... packages) {
        this.packages = Arrays.asList(packages);
        return this;
    }

    @Nonnull
    public HibernateModule scan(@Nonnull List<String> packages) {
        this.packages = packages;
        return this;
    }

    @Nonnull
    public HibernateModule with(@Nonnull SessionProvider sessionProvider) {
        this.sessionBuilder = sessionProvider;
        return this;
    }

    @Nonnull
    public HibernateModule with(@Nonnull HibernateConfigurer configurer) {
        this.configurer = configurer;
        return this;
    }

    public void install(@Nonnull Jooby application) {
        Environment env = application.getEnvironment();
        Config config = application.getConfig();
        ServiceRegistry registry = application.getServices();
        DataSource dataSource = (DataSource)registry.getOrNull(ServiceKey.key(DataSource.class, (String)this.name));
        boolean fallback = false;
        if (dataSource == null) {
            dataSource = (DataSource)registry.require(DataSource.class);
            fallback = true;
        }
        BootstrapServiceRegistryBuilder bsrb = new BootstrapServiceRegistryBuilder();
        boolean defaultDdlAuto = env.isActive("dev", new String[]{"test"});
        boolean flyway = HibernateModule.isFlywayPresent(env, registry, this.name, fallback);
        String ddlAuto = flyway ? "none" : (defaultDdlAuto ? "update" : "none");
        this.configurer.configure(bsrb, config);
        BootstrapServiceRegistry bsr = bsrb.build();
        StandardServiceRegistryBuilder ssrb = new StandardServiceRegistryBuilder(bsr);
        ssrb.applySetting("hibernate.hbm2ddl.auto", (Object)ddlAuto);
        ssrb.applySetting("hibernate.current_session_context_class", (Object)"managed");
        Map base = env.getProperties("hibernate");
        Map custom = env.getProperties(this.name + ".hibernate", "hibernate");
        HashMap settings = new HashMap();
        settings.putAll(base);
        settings.putAll(custom);
        ssrb.applySettings(settings);
        ssrb.applySetting("hibernate.connection.datasource", (Object)dataSource);
        ssrb.applySetting("hibernate.delay_cdi_access", (Object)true);
        this.configurer.configure(ssrb, config);
        StandardServiceRegistry serviceRegistry = ssrb.build();
        if (this.packages.isEmpty() && this.classes.isEmpty()) {
            this.packages = Stream.of(application.getBasePackage()).filter(Objects::nonNull).collect(Collectors.toList());
        }
        MetadataSources sources = new MetadataSources((org.hibernate.service.ServiceRegistry)serviceRegistry);
        this.packages.forEach(arg_0 -> ((MetadataSources)sources).addPackage(arg_0));
        this.classes.forEach(arg_0 -> ((MetadataSources)sources).addAnnotatedClass(arg_0));
        this.configurer.configure(sources, config);
        ClassLoader classLoader = env.getClassLoader();
        List<URL> packages = sources.getAnnotatedPackages().stream().map(pkg -> classLoader.getResource(pkg.replace('.', '/'))).collect(Collectors.toList());
        MetadataBuilder metadataBuilder = sources.getMetadataBuilder();
        if (packages.size() > 0) {
            metadataBuilder.applyScanEnvironment((ScanEnvironment)new ScanEnvImpl(packages));
        }
        this.configurer.configure(metadataBuilder, config);
        Metadata metadata = metadataBuilder.build();
        SessionFactoryBuilder sfb = metadata.getSessionFactoryBuilder();
        sfb.applyName(this.name);
        sfb.applyNameAsJndiName(false);
        this.configurer.configure(sfb, config);
        SessionFactory sf = sfb.build();
        SessionServiceProvider sessionServiceProvider = new SessionServiceProvider(sf, this.sessionBuilder);
        registry.putIfAbsent(Session.class, (Provider)sessionServiceProvider);
        registry.put(ServiceKey.key(Session.class, (String)this.name), (Provider)sessionServiceProvider);
        registry.putIfAbsent(EntityManager.class, (Provider)sessionServiceProvider);
        registry.put(ServiceKey.key(EntityManager.class, (String)this.name), (Provider)sessionServiceProvider);
        registry.putIfAbsent(SessionFactory.class, (Object)sf);
        registry.put(ServiceKey.key(SessionFactory.class, (String)this.name), (Object)sf);
        registry.putIfAbsent(EntityManagerFactory.class, (Object)sf);
        registry.put(ServiceKey.key(EntityManagerFactory.class, (String)this.name), (Object)sf);
        registry.putIfAbsent(SessionProvider.class, (Object)this.sessionBuilder);
        registry.put(ServiceKey.key(SessionProvider.class, (String)this.name), (Object)this.sessionBuilder);
        UnitOfWorkProvider unitOfWorkProvider = new UnitOfWorkProvider(sf, this.sessionBuilder);
        registry.putIfAbsent(UnitOfWork.class, (Provider)unitOfWorkProvider);
        registry.put(ServiceKey.key(UnitOfWork.class, (String)this.name), (Provider)unitOfWorkProvider);
        application.onStop(() -> ((SessionFactory)sf).close());
    }

    private static boolean isFlywayPresent(Environment env, ServiceRegistry registry, String key, boolean fallback) {
        Optional flyway = env.loadClass("org.flywaydb.core.Flyway");
        if (flyway.isPresent()) {
            if (registry.getOrNull(ServiceKey.key((Class)((Class)flyway.get()), (String)key)) != null) {
                return true;
            }
            return fallback && registry.getOrNull((Class)flyway.get()) != null;
        }
        return false;
    }
}

