/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.hibernate;

import io.jooby.hibernate.SessionProvider;
import io.jooby.hibernate.SessionRequest;
import io.jooby.hibernate.TransactionalRequest;
import io.jooby.hibernate.UnitOfWork;
import io.jooby.internal.hibernate.UnitOfWorkImpl;
import javax.inject.Provider;
import org.hibernate.SessionFactory;
import org.hibernate.context.internal.ManagedSessionContext;

public class UnitOfWorkProvider
implements Provider<UnitOfWork> {
    private final SessionFactory sessionFactory;
    private final SessionProvider sessionProvider;

    public UnitOfWorkProvider(SessionFactory sessionFactory, SessionProvider sessionProvider) {
        this.sessionFactory = sessionFactory;
        this.sessionProvider = sessionProvider;
    }

    public UnitOfWork get() {
        if (ManagedSessionContext.hasBind((SessionFactory)this.sessionFactory)) {
            throw new IllegalStateException("A session is already bound to the current thread. Don't nest " + UnitOfWork.class.getSimpleName() + " invocations or don't use " + UnitOfWork.class.getSimpleName() + " together with " + SessionRequest.class.getSimpleName() + " or " + TransactionalRequest.class.getSimpleName() + ".");
        }
        return new UnitOfWorkImpl(this.sessionProvider.newSession(this.sessionFactory.withOptions()));
    }
}

