/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.hibernate;

import io.jooby.Route;
import io.jooby.ServiceKey;
import io.jooby.SneakyThrows;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.context.internal.ManagedSessionContext;

public class TransactionalRequest
implements Route.Decorator {
    private ServiceKey<SessionFactory> key;

    public TransactionalRequest(@Nonnull String name) {
        this.key = ServiceKey.key(SessionFactory.class, (String)name);
    }

    public TransactionalRequest() {
        this.key = ServiceKey.key(SessionFactory.class);
    }

    @Nonnull
    public Route.Handler apply(@Nonnull Route.Handler next) {
        return (Route.Handler & Serializable)ctx -> {
            SessionFactory sessionFactory = (SessionFactory)ctx.require(this.key);
            Transaction trx = null;
            try {
                Session session = sessionFactory.openSession();
                ManagedSessionContext.bind((Session)session);
                trx = session.getTransaction();
                trx.begin();
                Object result = next.apply(ctx);
                if (trx.isActive()) {
                    trx.commit();
                }
                Object object = result;
                return object;
            }
            catch (Throwable x) {
                if (trx != null && trx.isActive()) {
                    trx.rollback();
                }
                throw SneakyThrows.propagate((Throwable)x);
            }
            finally {
                Session session = ManagedSessionContext.unbind((SessionFactory)sessionFactory);
                if (session != null) {
                    session.close();
                }
            }
        };
    }
}

