/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.email;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import io.jooby.internal.email.EmailFactory;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.ImageHtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;

public class CommonsEmailModule
implements Extension {
    private final String name;

    public CommonsEmailModule(String name) {
        this.name = Objects.requireNonNull(name, "Mail name is required.");
    }

    public CommonsEmailModule() {
        this("mail");
    }

    public void install(@Nonnull Jooby application) {
        Config config = CommonsEmailModule.mailConfig(application.getConfig(), this.name);
        ServiceRegistry services = application.getServices();
        EmailFactory factory = new EmailFactory(config);
        this.register(services, SimpleEmail.class, factory::newSimpleEmail);
        this.register(services, HtmlEmail.class, factory::newHtmlEmail);
        this.register(services, MultiPartEmail.class, factory::newMultiPartEmail);
        this.register(services, ImageHtmlEmail.class, factory::newImageHtmlEmail);
    }

    static Config mailConfig(Config config, String name) {
        Config mail = Stream.of(name, "mail").distinct().filter(arg_0 -> ((Config)config).hasPath(arg_0)).map(arg_0 -> ((Config)config).getConfig(arg_0)).reduce(Config::withFallback).orElseThrow(() -> new ConfigException.Missing(Stream.of(name, "mail").distinct().findFirst().get()));
        mail = mail.withFallback((ConfigMergeable)ConfigFactory.empty().withValue("charset", config.getValue("application.charset")));
        return mail;
    }

    private <T> void register(ServiceRegistry services, Class<T> clazz, Provider<T> provider) {
        services.putIfAbsent(clazz, provider);
        services.put(ServiceKey.key(clazz, (String)this.name), provider);
    }
}

