/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.camel;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServiceRegistry;
import io.jooby.internal.camel.JoobyCamelContext;
import io.jooby.internal.camel.SingletonProvider;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.main.SimpleMain;

public class CamelModule
implements Extension {
    private Function<CamelContext, List<RouteBuilder>> routes;
    private CamelContext camel;

    public CamelModule(CamelContext camel) {
        this.camel = camel;
    }

    public CamelModule(RouteBuilder route, RouteBuilder ... routes) {
        this.routes = registry -> CamelModule.concat(route, routes).collect(Collectors.toList());
    }

    public CamelModule(Class<? extends RouteBuilder> route, Class<? extends RouteBuilder> ... routes) {
        this.routes = camel -> CamelModule.concat(route, routes).map(type -> (RouteBuilder)camel.getInjector().newInstance(type)).collect(Collectors.toList());
    }

    public void install(@NonNull Jooby application) throws Exception {
        if (this.camel == null) {
            this.camel = CamelModule.newCamelContext(application);
        }
        SingletonProvider<ProducerTemplate> producerTemplate = new SingletonProvider<ProducerTemplate>(() -> ((CamelContext)this.camel).createProducerTemplate(), Service::close);
        SingletonProvider<FluentProducerTemplate> fluentProducerTemplate = new SingletonProvider<FluentProducerTemplate>(() -> ((CamelContext)this.camel).createFluentProducerTemplate(), Service::stop);
        SingletonProvider<ConsumerTemplate> consumerTemplate = new SingletonProvider<ConsumerTemplate>(() -> ((CamelContext)this.camel).createConsumerTemplate(), Service::stop);
        ServiceRegistry services = application.getServices();
        services.putIfAbsent(CamelContext.class, (Object)this.camel);
        if (this.camel instanceof DefaultCamelContext) {
            services.putIfAbsent(DefaultCamelContext.class, (Object)((DefaultCamelContext)this.camel));
        }
        services.putIfAbsent(ProducerTemplate.class, producerTemplate);
        services.putIfAbsent(FluentProducerTemplate.class, fluentProducerTemplate);
        services.putIfAbsent(ConsumerTemplate.class, consumerTemplate);
        SimpleMain main = new SimpleMain(this.camel);
        application.onStarting(() -> {
            main.init();
            List<RouteBuilder> routeList = this.routes.apply(this.camel);
            for (RouteBuilder route : routeList) {
                this.camel.addRoutes((RoutesBuilder)route);
            }
            main.start();
        });
        application.onStop(producerTemplate::close);
        application.onStop(fluentProducerTemplate::close);
        application.onStop(consumerTemplate::close);
        application.onStop(() -> ((SimpleMain)main).stop());
    }

    public static CamelContext newCamelContext(Jooby application) {
        return new JoobyCamelContext(application);
    }

    private static <T> Stream<T> concat(T route, T[] routes) {
        return Stream.concat(Stream.of(route), Stream.of(routes));
    }
}

