/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.camel;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.jooby.Jooby;
import io.jooby.Registry;
import io.jooby.internal.camel.JoobyBeanRepository;
import io.jooby.internal.camel.JoobyInjector;
import io.jooby.internal.camel.JoobyPropertiesSource;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.support.DefaultRegistry;

public class JoobyCamelContext
extends DefaultCamelContext {
    private Jooby application;

    public JoobyCamelContext(Jooby application) {
        super(false);
        this.application = application;
    }

    public DataFormat resolveDataFormat(String name) {
        return super.resolveDataFormat(name);
    }

    protected Injector createInjector() {
        return new JoobyInjector((CamelContext)this, (Registry)this.application);
    }

    protected org.apache.camel.spi.Registry createRegistry() {
        return new DefaultRegistry(new BeanRepository[]{new JoobyBeanRepository(this.application.getServices())});
    }

    protected PropertiesComponent createPropertiesComponent() {
        org.apache.camel.component.properties.PropertiesComponent properties = new org.apache.camel.component.properties.PropertiesComponent();
        properties.setInitialProperties(JoobyCamelContext.configureProperties(this.application));
        properties.addPropertiesSource((PropertiesSource)new JoobyPropertiesSource(this.application.getConfig()));
        return properties;
    }

    private static Properties configureProperties(Jooby application) {
        Properties properties = new Properties();
        properties.setProperty("camel.main.name", application.getName());
        properties.setProperty("camel.main.autoConfigurationLogSummary", "false");
        Config config = application.getConfig();
        if (config.hasPath("camel")) {
            for (Map.Entry prop : config.getConfig("camel").entrySet()) {
                properties.setProperty("camel." + (String)prop.getKey(), ((ConfigValue)prop.getValue()).unwrapped().toString());
            }
        }
        return properties;
    }
}

