/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.awssdkv1;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.WebIdentityTokenCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServiceRegistry;
import io.jooby.internal.awssdkv1.ConfigCredentialsProvider;
import io.jooby.internal.awssdkv1.ServiceShutdown;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class AwsModule
implements Extension {
    private final List<Function<AWSCredentialsProvider, Object>> factoryList = new ArrayList<Function<AWSCredentialsProvider, Object>>();

    @NonNull
    public AwsModule setup(@NonNull Function<AWSCredentialsProvider, Object> provider) {
        this.factoryList.add(provider);
        return this;
    }

    public void install(@NonNull Jooby application) throws Exception {
        AWSCredentialsProvider credentialsProvider = AwsModule.newCredentialsProvider(application.getConfig());
        ArrayList serviceList = new ArrayList(this.factoryList.size());
        for (Function<AWSCredentialsProvider, Object> factory : this.factoryList) {
            Object value = factory.apply(credentialsProvider);
            if (value instanceof Stream) {
                ((Stream)value).forEach(serviceList::add);
                continue;
            }
            if (value instanceof Collection) {
                ((Collection)value).forEach(serviceList::add);
                continue;
            }
            this.extractServices(value, serviceList::add);
        }
        ServiceRegistry services = application.getServices();
        for (Object service2 : serviceList) {
            Stream.of(service2.getClass(), Stream.of(service2.getClass().getInterfaces()).findFirst().orElse(null)).filter(Objects::nonNull).forEach(serviceType -> services.putIfAbsent(serviceType, service2));
        }
        serviceList.stream().distinct().forEach(service -> application.onStop((AutoCloseable)new ServiceShutdown(application.getLog(), service)));
        serviceList.clear();
        this.factoryList.clear();
    }

    @NonNull
    public static AWSCredentialsProvider newCredentialsProvider(@NonNull Config config) {
        return new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), WebIdentityTokenCredentialsProvider.create(), new ProfileCredentialsProvider(), new EC2ContainerCredentialsProviderWrapper(), new ConfigCredentialsProvider(config)});
    }

    private void extractServices(Object value, Consumer<Object> consumer) {
        this.transferManager(value, consumer);
        consumer.accept(value);
    }

    private void transferManager(Object value, Consumer<Object> consumer) {
        try {
            if (value instanceof TransferManager) {
                consumer.accept(((TransferManager)value).getAmazonS3Client());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

