/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.awssdkv1;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;

public class ConfigCredentialsProvider
implements AWSCredentialsProvider {
    private Config config;

    public ConfigCredentialsProvider(Config config) {
        this.config = config;
    }

    public AWSCredentials getCredentials() {
        try {
            return new BasicAWSCredentials(this.config.getString("aws.accessKeyId"), this.config.getString("aws.secretKey"));
        }
        catch (ConfigException.Missing x) {
            throw new SdkClientException("Unable to load AWS credentials from application properties (aws.accessKeyId and aws.secretKey)");
        }
    }

    public void refresh() {
    }
}

