/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.aws;

import com.amazonaws.AmazonWebServiceClient;
import io.jooby.SneakyThrows;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;

public class ServiceShutdown
implements AutoCloseable {
    private Object service;
    private Logger log;

    public ServiceShutdown(Logger log, Object service) {
        this.log = log;
        this.service = service;
    }

    @Override
    public void close() throws Exception {
        if (this.service instanceof AmazonWebServiceClient) {
            this.log.debug("Stopping {}", (Object)((AmazonWebServiceClient)this.service).getServiceName());
            ((AmazonWebServiceClient)this.service).shutdown();
        } else {
            try {
                this.log.debug("Stopping {}", (Object)this.service.getClass().getSimpleName());
                Method shutdown = Stream.of(this.shutdownMethod("shutdown"), this.shutdownMethod("shutdownNow")).filter(Objects::nonNull).findFirst().orElse(null);
                if (shutdown == null) {
                    this.log.info("Unable to stop {}", (Object)this.service.getClass().getSimpleName());
                } else {
                    shutdown.invoke(this.service, new Object[0]);
                }
            }
            catch (InvocationTargetException x) {
                throw SneakyThrows.propagate((Throwable)x.getCause());
            }
        }
    }

    private Method shutdownMethod(String name) {
        try {
            return this.service.getClass().getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException x) {
            return null;
        }
    }
}

