/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.panels;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.plaf.LayerUI;
import org.jmad.modelpack.gui.util.MoreSwingUtilities;

public class LoadLayerUI
extends LayerUI<JComponent> {
    private static final String REPAINT_EVENT = "LoadLayerUI_repaint";
    private boolean loading;

    @Override
    public void paint(Graphics graphics, JComponent component) {
        super.paint(graphics, component);
        if (this.loading) {
            Graphics2D overlay = (Graphics2D)graphics;
            Composite oldComposite = overlay.getComposite();
            overlay.setComposite(AlphaComposite.getInstance(3, 0.5f));
            overlay.setColor(Color.BLACK);
            overlay.fillRect(0, 0, component.getWidth(), component.getHeight());
            overlay.setComposite(oldComposite);
            overlay.setColor(Color.WHITE);
            String text = "Loading, please wait ...";
            Rectangle2D stringBounds = overlay.getFontMetrics().getStringBounds(text, overlay);
            overlay.drawString(text, (int)(((double)component.getWidth() - stringBounds.getWidth()) / 2.0), (int)(((double)component.getHeight() - stringBounds.getHeight()) / 2.0));
        }
    }

    @Override
    public void applyPropertyChange(PropertyChangeEvent evt, JLayer<? extends JComponent> layer) {
        if (evt.getPropertyName().equals(REPAINT_EVENT)) {
            layer.repaint();
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e, JLayer<? extends JComponent> l) {
        if (this.loading) {
            e.consume();
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e, JLayer<? extends JComponent> l) {
        if (this.loading) {
            e.consume();
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        ((JLayer)c).setLayerEventMask(24L);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        ((JLayer)c).setLayerEventMask(0L);
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
        MoreSwingUtilities.invokeOnSwingThread(() -> this.firePropertyChange(REPAINT_EVENT, null, null));
    }
}

