/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.panels;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jmad.modelpack.domain.VariantType;

class JMadVariantTypeFilterPanel
extends JPanel {
    private final Set<VariantType> enabledVariants = Collections.newSetFromMap(new ConcurrentHashMap());

    public JMadVariantTypeFilterPanel(Consumer<Set<VariantType>> selectionConsumer) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createTitledBorder("Filter"));
        this.enabledVariants.add(VariantType.RELEASE);
        for (VariantType variantType : VariantType.values()) {
            JCheckBox checkBox = new JCheckBox(variantType.toString().toLowerCase());
            checkBox.setSelected(this.enabledVariants.contains(variantType));
            checkBox.addActionListener(e -> {
                if (checkBox.isSelected()) {
                    this.enabledVariants.add(variantType);
                } else {
                    this.enabledVariants.remove(variantType);
                }
                selectionConsumer.accept(this.enabledVariants);
            });
            this.add(checkBox);
        }
        selectionConsumer.accept(this.enabledVariants);
    }
}

