/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.panels;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.jmad.modelpack.domain.JMadModelPackageRepository;
import org.jmad.modelpack.service.JMadModelPackageRepositoryManager;

public class JMadRepositorySelectionPanel
extends JPanel {
    public JMadRepositorySelectionPanel(JMadModelPackageRepositoryManager repositoryManager) {
        this.setLayout(new BorderLayout());
        RepositoryTableModel tableModel = new RepositoryTableModel((repository, state) -> {
            if (state == JMadModelPackageRepositoryManager.EnableState.ENABLED) {
                repositoryManager.enable(repository);
            } else if (state == JMadModelPackageRepositoryManager.EnableState.DISABLED) {
                repositoryManager.disable(repository);
            }
        });
        repositoryManager.state().subscribe(tableModel::setState);
        JTable table = new JTable(tableModel);
        this.add((Component)new JScrollPane(table), "Center");
        table.getColumnModel().getColumn(0).setMaxWidth(100);
    }

    private static class RepositoryTableModel
    extends AbstractTableModel {
        private static final int ENABLED_COLUMN = 0;
        private static final int REPOSITORY_COLUMN = 1;
        private Map<JMadModelPackageRepository, JMadModelPackageRepositoryManager.EnableState> enabledState = Collections.emptyMap();
        private List<JMadModelPackageRepository> orderedModelList = Collections.emptyList();
        private final BiConsumer<JMadModelPackageRepository, JMadModelPackageRepositoryManager.EnableState> enableConsumer;

        private RepositoryTableModel(BiConsumer<JMadModelPackageRepository, JMadModelPackageRepositoryManager.EnableState> enableConsumer) {
            this.enableConsumer = enableConsumer;
        }

        public synchronized void setState(Map<JMadModelPackageRepository, JMadModelPackageRepositoryManager.EnableState> state) {
            this.enabledState = ImmutableMap.copyOf(state);
            this.orderedModelList = state.keySet().stream().sorted(Comparator.comparing(JMadModelPackageRepository::uri)).collect(Collectors.toList());
            SwingUtilities.invokeLater(this::fireTableDataChanged);
        }

        @Override
        public synchronized int getRowCount() {
            return this.enabledState.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public synchronized Object getValueAt(int row, int column) {
            JMadModelPackageRepository repository = this.orderedModelList.get(row);
            if (column == 0) {
                return this.enabledState.get(repository).asBoolEnabled();
            }
            if (column == 1) {
                return repository;
            }
            throw new IllegalArgumentException("Illegal column: " + column);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return Boolean.class;
            }
            if (column == 1) {
                return JMadModelPackageRepository.class;
            }
            throw new IllegalArgumentException("Illegal column: " + column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public synchronized void setValueAt(Object aValue, int row, int column) {
            Preconditions.checkState((column == 0 ? 1 : 0) != 0, (Object)"Only enable state is editable");
            Preconditions.checkState((boolean)(aValue instanceof Boolean), (Object)"value must be boolean");
            boolean enabled = (Boolean)aValue;
            this.enableConsumer.accept(this.orderedModelList.get(row), enabled ? JMadModelPackageRepositoryManager.EnableState.ENABLED : JMadModelPackageRepositoryManager.EnableState.DISABLED);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Enabled";
            }
            if (column == 1) {
                return "Repository URI";
            }
            throw new IllegalArgumentException("Illegal column: " + column);
        }
    }
}

