/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.panels;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.TreeMultimap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.jmad.modelpack.domain.ModelPackage;
import org.jmad.modelpack.domain.ModelPackageVariant;
import org.jmad.modelpack.domain.ModelPackages;
import org.jmad.modelpack.domain.VariantType;
import org.jmad.modelpack.gui.panels.JMadVariantTypeFilterPanel;
import org.jmad.modelpack.gui.panels.LoadLayerUI;
import org.jmad.modelpack.gui.util.MoreSwingUtilities;
import org.jmad.modelpack.service.JMadModelPackageService;

class JMadModelPackSelectionPanel
extends JPanel {
    private final JMadModelPackageService service;
    private final Multimap<ModelPackage, ModelPackageVariant> availableModelPacks = Multimaps.synchronizedMultimap((Multimap)TreeMultimap.create(Comparator.comparing(ModelPackage::name), (Comparator)ModelPackages.latestFirstPackageVariantComparator()));
    private Set<VariantType> enabledVariantTypes;
    private final DefaultTreeTableModel modelPackTableModel;
    private final LoadLayerUI loadUi;

    public JMadModelPackSelectionPanel(JMadModelPackageService service, Consumer<ModelPackageVariant> consumer) {
        this.service = service;
        this.modelPackTableModel = new DefaultTreeTableModel(null, Arrays.asList("Model Pack", "Variant"));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Model Packages"));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(new JMadVariantTypeFilterPanel(this::variantFilterChanged));
        leftPanel.add(Box.createVerticalGlue());
        JButton reloadButton = new JButton("Refresh");
        reloadButton.addActionListener(e -> this.reloadAvailableModelPacks());
        leftPanel.add(reloadButton);
        leftPanel.add(Box.createVerticalStrut(5));
        JButton clearCacheButton = new JButton("Clear Cache");
        clearCacheButton.addActionListener(e -> service.clearCache().block());
        leftPanel.add(clearCacheButton);
        leftPanel.add(Box.createVerticalStrut(5));
        this.add((Component)leftPanel, "West");
        JXTreeTable treeTable = new JXTreeTable((TreeTableModel)this.modelPackTableModel);
        treeTable.setRootVisible(false);
        treeTable.setLeafIcon(null);
        treeTable.setClosedIcon(null);
        treeTable.setOpenIcon(null);
        treeTable.setSelectionMode(0);
        treeTable.addTreeSelectionListener(e -> {
            TreePath newSelection = e.getNewLeadSelectionPath();
            if (newSelection == null) {
                return;
            }
            consumer.accept(((ModelPackTreeTableNode)((Object)((Object)newSelection.getLastPathComponent()))).value());
        });
        this.loadUi = new LoadLayerUI();
        this.add(new JLayer<JComponent>(new JScrollPane((Component)treeTable), this.loadUi), "Center");
        this.reloadAvailableModelPacks();
    }

    private void reloadAvailableModelPacks() {
        this.loadUi.setLoading(true);
        this.modelPackTableModel.setRoot((TreeTableNode)new DefaultMutableTreeTableNode());
        this.availableModelPacks.clear();
        this.service.availablePackages().doOnTerminate(() -> this.loadUi.setLoading(false)).subscribe(mpv -> {
            this.availableModelPacks.put((Object)mpv.modelPackage(), mpv);
            MoreSwingUtilities.invokeOnSwingThread(this::refreshTable);
        });
    }

    private void variantFilterChanged(Set<VariantType> variantTypes) {
        this.enabledVariantTypes = variantTypes;
        this.refreshTable();
    }

    private void refreshTable() {
        DefaultMutableTreeTableNode root = new DefaultMutableTreeTableNode();
        Multimap filteredModelPackVariants = Multimaps.filterValues(this.availableModelPacks, mpv -> this.enabledVariantTypes.contains(mpv.variant().type()));
        for (ModelPackage modelPack : filteredModelPackVariants.keySet()) {
            ArrayList variants = new ArrayList(filteredModelPackVariants.get((Object)modelPack));
            ModelPackageVariant first = (ModelPackageVariant)variants.get(0);
            ModelPackTreeTableNode treeNode = new ModelPackTreeTableNode(first);
            variants.stream().skip(1L).map(x$0 -> new ModelPackTreeTableNode((ModelPackageVariant)x$0)).forEach(arg_0 -> ((ModelPackTreeTableNode)treeNode).add(arg_0));
            root.add((MutableTreeTableNode)treeNode);
        }
        this.modelPackTableModel.setRoot((TreeTableNode)root);
    }

    private static class ModelPackTreeTableNode
    extends AbstractMutableTreeTableNode {
        private static final int MODELPACK_COLUMN = 0;
        private static final int VARIANT_COLUMN = 1;
        private final ModelPackageVariant modelPackageVariant;

        private ModelPackTreeTableNode(ModelPackageVariant modelPackageVariant) {
            this.modelPackageVariant = modelPackageVariant;
        }

        public ModelPackageVariant value() {
            return this.modelPackageVariant;
        }

        public Object getValueAt(int column) {
            if (column == 0) {
                return this.modelPackageVariant.modelPackage().name();
            }
            if (column == 1) {
                return this.modelPackageVariant.variant().name() + " [" + this.modelPackageVariant.variant().type() + "]";
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        public int getColumnCount() {
            return 2;
        }
    }
}

