/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.domain;

import cern.accsoft.steering.jmad.model.JMadModelStartupConfiguration;
import cern.accsoft.steering.jmad.modeldefs.domain.JMadModelDefinition;
import java.util.Objects;
import java.util.Optional;

public class JMadModelSelection {
    private final JMadModelDefinition modelDefinition;
    private final JMadModelStartupConfiguration startupConfiguration;

    public JMadModelSelection(JMadModelDefinition modelDefinition) {
        this(modelDefinition, null);
    }

    public JMadModelSelection(JMadModelDefinition modelDefinition, JMadModelStartupConfiguration startupConfiguration) {
        this.modelDefinition = Objects.requireNonNull(modelDefinition, "modelDefinition must not be null");
        this.startupConfiguration = startupConfiguration;
    }

    public JMadModelDefinition modelDefinition() {
        return this.modelDefinition;
    }

    public Optional<JMadModelStartupConfiguration> startupConfiguration() {
        return Optional.ofNullable(this.startupConfiguration);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.modelDefinition == null ? 0 : this.modelDefinition.hashCode());
        result = 31 * result + (this.startupConfiguration == null ? 0 : this.startupConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JMadModelSelection other = (JMadModelSelection)obj;
        if (this.modelDefinition == null ? other.modelDefinition != null : !this.modelDefinition.equals(other.modelDefinition)) {
            return false;
        }
        return !(this.startupConfiguration == null ? other.startupConfiguration != null : !this.startupConfiguration.equals(other.startupConfiguration));
    }

    public String toString() {
        return "JMadModelSelection [modelDefinition=" + this.modelDefinition + ", startupConfiguration=" + this.startupConfiguration + "]";
    }
}

