/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.panels;

import cern.accsoft.steering.jmad.domain.machine.RangeDefinition;
import cern.accsoft.steering.jmad.domain.machine.SequenceDefinition;
import cern.accsoft.steering.jmad.model.JMadModelStartupConfiguration;
import cern.accsoft.steering.jmad.modeldefs.domain.JMadModelDefinition;
import cern.accsoft.steering.jmad.modeldefs.domain.OpticsDefinition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jmad.modelpack.domain.ModelPackageVariant;
import org.jmad.modelpack.gui.domain.JMadModelSelection;
import org.jmad.modelpack.gui.domain.JMadModelSelectionType;
import org.jmad.modelpack.gui.panels.LoadLayerUI;
import org.jmad.modelpack.gui.util.MoreSwingUtilities;
import org.jmad.modelpack.service.JMadModelPackageService;

class JMadModelDefinitionSelectionPanel
extends JPanel {
    private final JMadModelPackageService service;
    private final JList<JMadModelDefinition> modelDefinitionSelector;
    private final JComboBox<SequenceDefinition> sequenceDefinitionSelector;
    private final JComboBox<RangeDefinition> rangeDefinitionSelector;
    private final JList<OpticsDefinition> opticsDefinitionSelector;
    private final LoadLayerUI loadUi;

    public JMadModelDefinitionSelectionPanel(JMadModelPackageService service, JMadModelSelectionType selectionType) {
        this.service = service;
        this.loadUi = new LoadLayerUI();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(300, 500));
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        JPanel modelDefinitionPanel = new JPanel();
        modelDefinitionPanel.setLayout(new BorderLayout());
        modelDefinitionPanel.setBorder(BorderFactory.createTitledBorder("Model Definitions"));
        this.modelDefinitionSelector = new JList();
        this.modelDefinitionSelector.addListSelectionListener(e -> this.modelDefinitionSelectionChanged());
        modelDefinitionPanel.add((Component)new JScrollPane(this.modelDefinitionSelector), "Center");
        content.add((Component)modelDefinitionPanel, "Center");
        if (selectionType == JMadModelSelectionType.ALL) {
            JPanel modelConfigPanel = new JPanel();
            this.sequenceDefinitionSelector = new JComboBox();
            this.sequenceDefinitionSelector.addActionListener(e -> this.sequenceSelectionChanged());
            this.rangeDefinitionSelector = new JComboBox();
            this.opticsDefinitionSelector = new JList();
            this.opticsDefinitionSelector.setMinimumSize(new Dimension(50, 100));
            modelConfigPanel.setBorder(BorderFactory.createTitledBorder("Model Configuration"));
            modelConfigPanel.setLayout(new BoxLayout(modelConfigPanel, 1));
            modelConfigPanel.add(new JLabel("Sequence:"));
            modelConfigPanel.add(this.sequenceDefinitionSelector);
            modelConfigPanel.add(Box.createVerticalStrut(5));
            modelConfigPanel.add(new JLabel("Range:"));
            modelConfigPanel.add(this.rangeDefinitionSelector);
            modelConfigPanel.add(Box.createVerticalStrut(5));
            modelConfigPanel.add(new JLabel("Optic:"));
            modelConfigPanel.add(new JScrollPane(this.opticsDefinitionSelector));
            Arrays.stream(modelConfigPanel.getComponents()).forEach(c -> ((JComponent)c).setAlignmentX(0.0f));
            content.add((Component)modelConfigPanel, "South");
        } else {
            this.sequenceDefinitionSelector = null;
            this.rangeDefinitionSelector = null;
            this.opticsDefinitionSelector = null;
        }
        this.add(new JLayer<JComponent>(content, this.loadUi), "Center");
    }

    private void modelDefinitionSelectionChanged() {
        JMadModelDefinition modelDef = this.modelDefinitionSelector.getSelectedValue();
        if (modelDef == null) {
            Optional.ofNullable(this.sequenceDefinitionSelector).ifPresent(s -> s.setModel(new DefaultComboBoxModel()));
            Optional.ofNullable(this.rangeDefinitionSelector).ifPresent(s -> s.setModel(new DefaultComboBoxModel()));
            Optional.ofNullable(this.opticsDefinitionSelector).ifPresent(s -> s.setModel(new DefaultListModel()));
            return;
        }
        if (this.sequenceDefinitionSelector != null) {
            SequenceDefinition[] sequenceDefinitions = modelDef.getSequenceDefinitions().toArray(new SequenceDefinition[0]);
            this.sequenceDefinitionSelector.setModel(new DefaultComboBoxModel<SequenceDefinition>(sequenceDefinitions));
            this.sequenceDefinitionSelector.setSelectedItem(modelDef.getDefaultSequenceDefinition());
            this.sequenceSelectionChanged();
        }
        if (this.opticsDefinitionSelector != null) {
            DefaultListModel newModel = new DefaultListModel();
            modelDef.getOpticsDefinitions().forEach(newModel::addElement);
            this.opticsDefinitionSelector.setModel(newModel);
            this.opticsDefinitionSelector.setSelectedValue(modelDef.getDefaultOpticsDefinition(), true);
        }
    }

    private void sequenceSelectionChanged() {
        if (this.sequenceDefinitionSelector == null || this.rangeDefinitionSelector == null) {
            return;
        }
        SequenceDefinition sequenceDefinition = (SequenceDefinition)this.sequenceDefinitionSelector.getSelectedItem();
        if (sequenceDefinition == null) {
            return;
        }
        RangeDefinition[] rangeDefinitions = sequenceDefinition.getRangeDefinitions().toArray(new RangeDefinition[0]);
        this.rangeDefinitionSelector.setModel(new DefaultComboBoxModel<RangeDefinition>(rangeDefinitions));
        this.rangeDefinitionSelector.setSelectedItem(sequenceDefinition.getDefaultRangeDefinition());
    }

    public void setModelPack(ModelPackageVariant modelPack) {
        DefaultListModel newModel = new DefaultListModel();
        this.loadUi.setLoading(true);
        this.service.modelDefinitionsFrom(modelPack).doOnTerminate(() -> this.loadUi.setLoading(false)).subscribe(newModel::addElement);
        this.modelDefinitionSelector.setModel(newModel);
        MoreSwingUtilities.invokeOnSwingThread(this::modelDefinitionSelectionChanged);
    }

    public JMadModelSelection getModelSelection() {
        JMadModelDefinition selectedModel = this.modelDefinitionSelector.getSelectedValue();
        if (selectedModel == null) {
            return null;
        }
        if (this.rangeDefinitionSelector != null && this.opticsDefinitionSelector != null) {
            JMadModelStartupConfiguration startupConfiguration = new JMadModelStartupConfiguration();
            startupConfiguration.setInitialRangeDefinition((RangeDefinition)this.rangeDefinitionSelector.getSelectedItem());
            startupConfiguration.setInitialOpticsDefinition(this.opticsDefinitionSelector.getSelectedValue());
            return new JMadModelSelection(selectedModel, startupConfiguration);
        }
        return new JMadModelSelection(selectedModel);
    }
}

