/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jmad.modelpack.gui.domain.JMadModelSelection;
import org.jmad.modelpack.gui.domain.JMadModelSelectionType;
import org.jmad.modelpack.gui.panels.JMadModelSelectionPanel;
import org.jmad.modelpack.gui.panels.JMadRepositorySelectionPanel;
import org.jmad.modelpack.service.JMadModelPackageRepositoryManager;
import org.jmad.modelpack.service.JMadModelPackageService;

public class JMadModelSelectionDialog
extends JDialog {
    private JMadModelSelection modelSelection = null;

    public JMadModelSelectionDialog(JMadModelPackageService service, JMadModelSelectionType selectionType, JMadModelPackageRepositoryManager repositoryManager) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(1000, 800));
        JMadModelSelectionPanel modelSelectionPanel = new JMadModelSelectionPanel(service, selectionType);
        JMadRepositorySelectionPanel repositorySelectionPanel = new JMadRepositorySelectionPanel(repositoryManager);
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.addTab("Available models", modelSelectionPanel);
        tabPane.addTab("Models repositories", repositorySelectionPanel);
        this.add((Component)tabPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> {
            this.modelSelection = modelSelectionPanel.getModelSelection();
            if (this.modelSelection == null) {
                JOptionPane.showMessageDialog(this, "Please select a model!");
            } else {
                this.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            this.modelSelection = null;
            this.setVisible(false);
        });
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(okButton);
        this.add((Component)buttonPanel, "South");
        this.pack();
    }

    public synchronized Optional<JMadModelSelection> getModelSelection() {
        return Optional.ofNullable(this.modelSelection);
    }
}

