/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.conf;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jmad.modelpack.gui.dialogs.JMadModelSelectionDialog;
import org.jmad.modelpack.gui.domain.JMadModelSelection;
import org.jmad.modelpack.gui.domain.JMadModelSelectionType;
import org.jmad.modelpack.gui.util.MoreSwingUtilities;
import org.jmad.modelpack.service.JMadModelPackageRepositoryManager;
import org.jmad.modelpack.service.JMadModelPackageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="jmadModelSelectionDialogFactory")
@Lazy
public class JMadModelSelectionDialogFactory {
    @Autowired
    private JMadModelPackageService packageService;
    @Autowired
    private JMadModelPackageRepositoryManager repositoryManager;

    public Optional<JMadModelSelection> showAndWaitModelSelection() {
        return this.showAndWaitModelSelection(JMadModelSelectionType.ALL);
    }

    public Optional<JMadModelSelection> showAndWaitModelSelection(JMadModelSelectionType selectionType) {
        AtomicReference userSelection = new AtomicReference();
        MoreSwingUtilities.invokeOnSwingThread(() -> {
            JMadModelSelectionDialog modelSelectionDialog = new JMadModelSelectionDialog(this.packageService, selectionType, this.repositoryManager);
            modelSelectionDialog.setModal(true);
            modelSelectionDialog.setVisible(true);
            userSelection.set(modelSelectionDialog.getModelSelection());
        });
        return (Optional)userSelection.get();
    }
}

