/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.panes;

import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.VBox;
import org.jmad.modelpack.domain.ModelPackageVariant;
import org.jmad.modelpack.domain.VariantType;
import org.jmad.modelpack.gui.util.GuiUtils;

public class VariantTypeFilterControl
extends VBox {
    private final BooleanProperty showReleases = new SimpleBooleanProperty(true);
    private final BooleanProperty showTags = new SimpleBooleanProperty(false);
    private final BooleanProperty showBranches = new SimpleBooleanProperty(false);
    private final ObjectProperty<Predicate<ModelPackageVariant>> predicate = new SimpleObjectProperty(pv -> true);

    public VariantTypeFilterControl() {
        ObjectBinding objectBinding = Bindings.createObjectBinding(() -> pv -> {
            VariantType variant = pv.variant().type();
            if (VariantType.RELEASE == variant && !this.showReleases.get()) {
                return false;
            }
            if (VariantType.TAG == variant && !this.showTags.get()) {
                return false;
            }
            return VariantType.BRANCH != variant || this.showBranches.get();
        }, (Observable[])new Observable[]{this.showTags, this.showReleases, this.showBranches});
        this.predicate.bind((ObservableValue)objectBinding);
        this.setSpacing(8.0);
        this.setPadding(GuiUtils.DEFAULT_SPACING_INSETS);
        this.addCheckBox("releases", this.showReleases);
        this.addCheckBox("tags", this.showTags);
        this.addCheckBox("branches", this.showBranches);
    }

    public BooleanProperty showTagsProperty() {
        return this.showTags;
    }

    public BooleanProperty showReleasesProperty() {
        return this.showReleases;
    }

    public BooleanProperty showBranchesProperty() {
        return this.showBranches;
    }

    public ObjectProperty<Predicate<ModelPackageVariant>> variantFilterProperty() {
        return this.predicate;
    }

    private void addCheckBox(String text, BooleanProperty prop) {
        CheckBox checkBox = new CheckBox(text);
        checkBox.setSelected(prop.get());
        prop.bind((ObservableValue)checkBox.selectedProperty());
        this.getChildren().add((Object)checkBox);
    }
}

