/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.panes;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.text.FontWeight;
import javafx.util.Duration;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.jmad.modelpack.gui.util.FxUtils;

public class SectionPane
extends AnchorPane {
    private static final double LOADING_GLYPH_SIZE = 24.0;
    private static final int REFRESH_ANIMATION_MS = 600;
    private final Region loadingPane;
    private final Animation loadingAnimation;
    private final TitledPane titledContentPane;
    private final BooleanProperty loadingOverlayProperty = new SimpleBooleanProperty(false);

    public SectionPane() {
        this("");
    }

    public SectionPane(String title) {
        this.titledContentPane = new TitledPane();
        this.titledContentPane.setText(title);
        this.titledContentPane.setCollapsible(false);
        FxUtils.setFontWeight(this.titledContentPane, FontWeight.BOLD);
        this.loadingPane = SectionPane.createLoadingPane();
        this.loadingAnimation = SectionPane.createRotateAnimation((Node)this.loadingPane);
        FxUtils.glueToAnchorPane((Node)this.titledContentPane);
        FxUtils.glueToAnchorPane((Node)this.loadingPane);
        this.getChildren().addAll((Object[])new Node[]{this.titledContentPane, this.loadingPane});
        this.loadingOverlayProperty.addListener(FxUtils.onChange(enabled -> {
            if (enabled.booleanValue()) {
                this.showLoading();
            } else {
                this.hideLoading();
            }
        }));
        this.hideLoading();
    }

    public void setTitle(String title) {
        this.titledContentPane.setText(title);
    }

    public void setContent(Node content) {
        this.titledContentPane.setContent(content);
    }

    public void hideLoading() {
        this.loadingAnimation.stop();
        this.loadingPane.setVisible(false);
        this.titledContentPane.setDisable(false);
    }

    public void showLoading() {
        this.titledContentPane.setDisable(true);
        this.loadingPane.setVisible(true);
        this.loadingAnimation.playFromStart();
    }

    public BooleanProperty loadingOverlayProperty() {
        return this.loadingOverlayProperty;
    }

    public StringProperty textProperty() {
        return this.titledContentPane.textProperty();
    }

    private static Region createLoadingPane() {
        Glyph loadingPane = GlyphFontRegistry.font((String)"FontAwesome").create((Enum)FontAwesome.Glyph.SPINNER);
        loadingPane.setCacheHint(CacheHint.ROTATE);
        loadingPane.setFontSize(24.0);
        loadingPane.setColor(Color.GRAY);
        return new StackPane(new Node[]{loadingPane});
    }

    private static Animation createRotateAnimation(Node graphics) {
        RotateTransition transition = new RotateTransition(Duration.millis((double)600.0), graphics);
        transition.setFromAngle(0.0);
        transition.setToAngle(360.0);
        transition.setCycleCount(-1);
        transition.setInterpolator(Interpolator.LINEAR);
        return transition;
    }
}

