/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.panes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import freetimelabs.io.reactorfx.schedulers.FxSchedulers;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.layout.BorderPane;
import org.jmad.modelpack.domain.JMadModelPackageRepository;
import org.jmad.modelpack.gui.util.FxUtils;
import org.jmad.modelpack.service.JMadModelPackageRepositoryManager;

public class JMadModelRepositorySelectionControl
extends BorderPane {
    private final JMadModelPackageRepositoryManager manager;

    public JMadModelRepositorySelectionControl(JMadModelPackageRepositoryManager manager) {
        this.manager = Objects.requireNonNull(manager, "manager must not be null");
        ObservableList repos = FXCollections.observableArrayList();
        TableView repositoryView = new TableView(repos);
        repositoryView.setEditable(true);
        TableColumn enabledCol = new TableColumn("Enabled");
        enabledCol.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)enabledCol));
        enabledCol.setCellValueFactory(r -> ((RepoLine)r.getValue()).enabled);
        enabledCol.setEditable(true);
        TableColumn baseUrlCol = new TableColumn("Repository");
        baseUrlCol.setCellValueFactory(r -> ((RepoLine)r.getValue()).stringRepresentation);
        baseUrlCol.setEditable(false);
        baseUrlCol.setResizable(true);
        repositoryView.getColumns().addAll((Collection)ImmutableList.of((Object)enabledCol, (Object)baseUrlCol));
        FxUtils.setPercentageWidth(repositoryView, ImmutableMap.of((Object)enabledCol, (Object)0.1, (Object)baseUrlCol, (Object)0.9));
        this.setCenter((Node)repositoryView);
        manager.state().map(this::repoList).publishOn(FxSchedulers.fxThread()).subscribe(arg_0 -> ((ObservableList)repos).setAll(arg_0));
    }

    private List<RepoLine> repoList(Map<JMadModelPackageRepository, JMadModelPackageRepositoryManager.EnableState> m) {
        return m.entrySet().stream().map(e -> new RepoLine((JMadModelPackageRepository)e.getKey(), ((JMadModelPackageRepositoryManager.EnableState)e.getValue()).asBoolEnabled())).sorted(Comparator.comparing(l -> ((RepoLine)l).stringRepresentation.getValue())).collect(Collectors.toList());
    }

    private class RepoLine {
        private final BooleanProperty enabled = new SimpleBooleanProperty();
        private final StringProperty stringRepresentation = new SimpleStringProperty();

        private RepoLine(JMadModelPackageRepository repo, boolean enabled) {
            this.stringRepresentation.set((Object)repo.toString());
            this.enabled.set(enabled);
            this.enabled.addListener(FxUtils.onChange(n -> {
                if (n.booleanValue()) {
                    JMadModelRepositorySelectionControl.this.manager.enable(repo);
                } else {
                    JMadModelRepositorySelectionControl.this.manager.disable(repo);
                }
            }));
        }
    }
}

