/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.panes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import freetimelabs.io.reactorfx.schedulers.FxSchedulers;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.FontWeight;
import org.controlsfx.control.ToggleSwitch;
import org.jmad.modelpack.domain.ModelPackage;
import org.jmad.modelpack.domain.ModelPackageVariant;
import org.jmad.modelpack.domain.ModelPackages;
import org.jmad.modelpack.domain.Variant;
import org.jmad.modelpack.gui.domain.ModelPackSelectionState;
import org.jmad.modelpack.gui.panes.SectionPane;
import org.jmad.modelpack.gui.panes.VariantTypeFilterControl;
import org.jmad.modelpack.gui.util.FxUtils;
import org.jmad.modelpack.service.JMadModelPackageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMadModelPackagesSelectionControl
extends AnchorPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMadModelPackagesSelectionControl.class);
    private static final Duration AVAILABLE_PACKAGES_REFRESH_TIMEOUT = Duration.ofSeconds(30L);
    private static final Duration CLEAR_CACHE_TIMEOUT = Duration.ofSeconds(30L);
    private static final int OPTIONS_PANE_PREF_WIDTH = 120;
    private final JMadModelPackageService packageService;
    private final ModelPackSelectionState state;
    private final VariantTypeFilterControl filterControl;
    private final TreeItem<PackageLine> packagesTableRoot;
    private final SetMultimap<ModelPackage, ModelPackageVariant> map;
    private final SectionPane contentPane;

    public JMadModelPackagesSelectionControl(JMadModelPackageService packageService, ModelPackSelectionState state) {
        this.packageService = Objects.requireNonNull(packageService, "packageService must not be null");
        this.state = Objects.requireNonNull(state, "modelpack selection state must not be null");
        this.map = TreeMultimap.create(Comparator.comparing(ModelPackage::name), (Comparator)ModelPackages.latestFirstPackageVariantComparator());
        this.filterControl = new VariantTypeFilterControl();
        this.packagesTableRoot = new TreeItem((Object)new PackageLine());
        VBox optionsPane = this.createPackagesOptionsPane(state);
        TreeTableView<PackageLine> packagesTable = this.createPackagesSelectionTable(state);
        HBox box = new HBox(new Node[]{optionsPane, packagesTable});
        box.setSpacing(8.0);
        box.setPadding(new Insets(8.0));
        box.setFillHeight(true);
        HBox.setHgrow(packagesTable, (Priority)Priority.ALWAYS);
        this.contentPane = new SectionPane("Model Packages");
        this.contentPane.setContent((Node)box);
        FxUtils.glueToAnchorPane((Node)this.contentPane);
        this.getChildren().add((Object)this.contentPane);
        this.updatePackages();
        this.filterControl.variantFilterProperty().addListener(FxUtils.onChange(v -> this.updatePackagesTableView()));
    }

    private VBox createPackagesOptionsPane(ModelPackSelectionState state) {
        Button refreshButton = new Button("Refresh");
        Button clearCacheButton = new Button("Clear cache");
        ToggleSwitch onlineSwitch = new ToggleSwitch("Online");
        onlineSwitch.setSelected(state.onlineModeProperty().get());
        onlineSwitch.selectedProperty().addListener(FxUtils.onChange(arg_0 -> ((BooleanProperty)state.onlineModeProperty()).set(arg_0)));
        onlineSwitch.selectedProperty().addListener(FxUtils.onChange(v -> this.updatePackages()));
        refreshButton.setOnAction(e -> this.updatePackages());
        clearCacheButton.setOnAction(e -> this.clearCache());
        TitledPane variantFilters = new TitledPane("Filters", (Node)this.filterControl);
        variantFilters.setCollapsible(false);
        FxUtils.setFontWeight(variantFilters, FontWeight.BOLD);
        VBox box = new VBox();
        box.setPrefWidth(120.0);
        box.setSpacing(8.0);
        box.getChildren().add((Object)variantFilters);
        box.getChildren().add((Object)FxUtils.wrapAndGlueToAnchorPane((Node)onlineSwitch));
        box.getChildren().add((Object)FxUtils.wrapAndGlueToAnchorPane((Node)refreshButton));
        box.getChildren().add((Object)FxUtils.createVerticalFiller());
        box.getChildren().add((Object)FxUtils.wrapAndGlueToAnchorPane((Node)clearCacheButton));
        box.setFillWidth(true);
        return box;
    }

    private TreeTableView<PackageLine> createPackagesSelectionTable(ModelPackSelectionState selectionModel) {
        TreeTableColumn packageColumn = new TreeTableColumn("Package Name");
        packageColumn.setCellValueFactory(param -> ((PackageLine)param.getValue().getValue()).packageNameProperty());
        TreeTableColumn variantColumn = new TreeTableColumn("Variant");
        variantColumn.setCellValueFactory(param -> ((PackageLine)param.getValue().getValue()).variantProperty());
        TreeTableView packagesTable = new TreeTableView(this.packagesTableRoot);
        packagesTable.setShowRoot(false);
        packagesTable.getColumns().setAll((Object[])new TreeTableColumn[]{packageColumn, variantColumn});
        selectionModel.selectedPackageProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            TreeItem treeItem = (TreeItem)packagesTable.getSelectionModel().selectedItemProperty().get();
            if (treeItem == null) {
                return null;
            }
            return ((PackageLine)treeItem.getValue()).modelPackageVariant;
        }, (Observable[])new Observable[]{packagesTable.getSelectionModel().selectedItemProperty()}));
        FxUtils.setPercentageWidth(packagesTable, ImmutableMap.of((Object)packageColumn, (Object)0.7, (Object)variantColumn, (Object)0.3));
        return packagesTable;
    }

    private void clearCache() {
        this.packageService.clearCache().doOnSubscribe(s -> this.showLoading()).subscribeOn(FxSchedulers.fxThread()).publishOn(FxSchedulers.fxThread()).timeout(CLEAR_CACHE_TIMEOUT).doOnError(e -> {
            LOGGER.error("Error while clearing the service cache", e);
            this.hideLoading();
        }).doOnSuccess(v -> this.hideLoading()).subscribe();
    }

    private void updatePackages() {
        this.clearPackages();
        this.packageService.availablePackages().doOnSubscribe(s -> this.showLoading()).publishOn(FxSchedulers.fxThread()).subscribeOn(FxSchedulers.fxThread()).timeout(AVAILABLE_PACKAGES_REFRESH_TIMEOUT).doOnComplete(this::hideLoading).doOnError(e -> {
            LOGGER.error("Error while retrieving available packages", e);
            this.hideLoading();
        }).subscribe(this::addPackage);
    }

    private void hideLoading() {
        this.state.loadingProperty().set(false);
        this.contentPane.hideLoading();
    }

    private void showLoading() {
        this.state.loadingProperty().set(true);
        this.contentPane.showLoading();
    }

    private void addPackage(ModelPackageVariant line) {
        this.map.put((Object)line.modelPackage(), (Object)line);
        this.updatePackagesTableView();
    }

    private void clearPackages() {
        this.map.clear();
        this.packagesTableRoot.getChildren().clear();
    }

    private void updatePackagesTableView() {
        List<TreeItem<PackageLine>> treeItems = JMadModelPackagesSelectionControl.treeItemsFor(this.map, (Predicate)this.filterControl.variantFilterProperty().get());
        this.packagesTableRoot.getChildren().setAll(treeItems);
    }

    private static List<TreeItem<PackageLine>> treeItemsFor(SetMultimap<ModelPackage, ModelPackageVariant> packages, Predicate<ModelPackageVariant> filter) {
        return packages.keySet().stream().map(modelPackage -> {
            Set packageVariants = packages.get(modelPackage);
            return packageVariants.stream().filter(filter).map(x$0 -> new PackageLine((ModelPackageVariant)x$0)).collect(Collectors.toList());
        }).filter(pkgLines -> !pkgLines.isEmpty()).map(variants -> {
            TreeItem item = new TreeItem(variants.get(0));
            List children = variants.subList(1, variants.size()).stream().map(TreeItem::new).collect(Collectors.toList());
            item.getChildren().setAll(children);
            return item;
        }).collect(Collectors.toList());
    }

    private static class PackageLine {
        private final ModelPackageVariant modelPackageVariant;
        private final StringProperty packageName = new SimpleStringProperty();
        private final StringProperty variant = new SimpleStringProperty();

        private PackageLine(ModelPackageVariant variant) {
            this.modelPackageVariant = Objects.requireNonNull(variant, "modelPackageVariant must not be null");
            this.packageName.set((Object)variant.modelPackage().name());
            this.variant.set((Object)PackageLine.stringFor(variant.variant()));
        }

        private static String stringFor(Variant variant) {
            return variant.name() + " [" + variant.type() + "]";
        }

        private PackageLine() {
            this.modelPackageVariant = null;
        }

        private StringProperty packageNameProperty() {
            return this.packageName;
        }

        private StringProperty variantProperty() {
            return this.variant;
        }
    }
}

