/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.panes;

import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jmad.modelpack.gui.domain.JMadModelSelectionType;
import org.jmad.modelpack.gui.domain.ModelPackSelectionState;
import org.jmad.modelpack.gui.panes.SectionPane;
import org.jmad.modelpack.gui.util.FxUtils;
import org.jmad.modelpack.gui.util.GuiUtils;

public class JMadModelDefinitionSelectionControl
extends AnchorPane {
    private static final double COMBOBOX_MIN_WIDTH = 150.0;
    private final ModelPackSelectionState state;

    public JMadModelDefinitionSelectionControl(ModelPackSelectionState state) {
        this.state = Objects.requireNonNull(state, "state must not be null");
        this.init();
    }

    private void init() {
        SectionPane modelDefinitionPane = JMadModelDefinitionSelectionControl.createModelDefinitionPane(this.state);
        SectionPane opticsPane = JMadModelDefinitionSelectionControl.createOpticsPane(this.state);
        this.state.loadingProperty().addListener(FxUtils.onChange(loading -> {
            modelDefinitionPane.loadingOverlayProperty().set(loading.booleanValue());
            opticsPane.loadingOverlayProperty().set(loading.booleanValue());
        }));
        VBox box = new VBox();
        box.setFillWidth(true);
        box.setSpacing(8.0);
        VBox.setVgrow((Node)modelDefinitionPane, (Priority)Priority.ALWAYS);
        box.getChildren().addAll((Object[])new Node[]{modelDefinitionPane, opticsPane});
        FxUtils.glueToAnchorPane((Node)box);
        this.getChildren().add((Object)box);
    }

    private static SectionPane createModelDefinitionPane(ModelPackSelectionState state) {
        ListView definitionView = new ListView(state.availableDefinitionsProperty());
        definitionView.getSelectionModel().selectedItemProperty().addListener(FxUtils.onChange(arg_0 -> state.selectedModelDefinitionProperty().set(arg_0)));
        state.selectedModelDefinitionProperty().addListener(FxUtils.onChange(arg_0 -> ((MultipleSelectionModel)definitionView.getSelectionModel()).select(arg_0)));
        SectionPane sectionPane = new SectionPane("Model Definitions");
        sectionPane.setContent((Node)definitionView);
        return sectionPane;
    }

    private static SectionPane createOpticsPane(ModelPackSelectionState state) {
        ComboBox sequenceCombo = new ComboBox();
        sequenceCombo.setMinWidth(150.0);
        sequenceCombo.itemsProperty().bind(state.availableSequencesProperty());
        sequenceCombo.getSelectionModel().selectedItemProperty().addListener(FxUtils.onChange(arg_0 -> state.selectedSequenceProperty().set(arg_0)));
        state.selectedSequenceProperty().addListener(FxUtils.onChange(arg_0 -> ((SingleSelectionModel)sequenceCombo.getSelectionModel()).select(arg_0)));
        ComboBox rangeCombo = new ComboBox();
        rangeCombo.setMinWidth(150.0);
        rangeCombo.itemsProperty().bind(state.availableRangesProperty());
        rangeCombo.getSelectionModel().selectedItemProperty().addListener(FxUtils.onChange(arg_0 -> state.selectedRangeProperty().set(arg_0)));
        state.selectedRangeProperty().addListener(FxUtils.onChange(arg_0 -> ((SingleSelectionModel)rangeCombo.getSelectionModel()).select(arg_0)));
        ListView opticsDefinitions = new ListView();
        opticsDefinitions.itemsProperty().bind(state.availableOpticsProperty());
        opticsDefinitions.getSelectionModel().selectedItemProperty().addListener(FxUtils.onChange(arg_0 -> state.selectedOpticsProperty().set(arg_0)));
        state.selectedOpticsProperty().addListener(FxUtils.onChange(arg_0 -> ((MultipleSelectionModel)opticsDefinitions.getSelectionModel()).select(arg_0)));
        StackPane sequenceControlContainer = new StackPane();
        StackPane rangeControlContainer = new StackPane();
        StackPane opticsDefinitionControlContainer = new StackPane();
        Consumer<JMadModelSelectionType> modelSelectionTypeUpdater = type -> {
            sequenceControlContainer.getChildren().clear();
            rangeControlContainer.getChildren().clear();
            opticsDefinitionControlContainer.getChildren().clear();
            if (type == JMadModelSelectionType.ALL) {
                sequenceControlContainer.getChildren().add((Object)sequenceCombo);
                rangeControlContainer.getChildren().add((Object)rangeCombo);
                opticsDefinitionControlContainer.getChildren().add((Object)opticsDefinitions);
            } else if (type == JMadModelSelectionType.MODEL_DEFINITION_ONLY) {
                sequenceControlContainer.getChildren().add((Object)new Label("ALL"));
                rangeControlContainer.getChildren().add((Object)new Label("ALL"));
                opticsDefinitionControlContainer.getChildren().add((Object)new Label("ALL"));
            }
        };
        state.modelSelectionTypeProperty().addListener(FxUtils.onChange(modelSelectionTypeUpdater));
        modelSelectionTypeUpdater.accept((JMadModelSelectionType)((Object)state.modelSelectionTypeProperty().get()));
        VBox box = new VBox();
        box.setPadding(GuiUtils.DEFAULT_SPACING_INSETS);
        box.setFillWidth(true);
        VBox.setVgrow((Node)opticsDefinitions, (Priority)Priority.ALWAYS);
        box.getChildren().add((Object)new Label("Sequence:"));
        box.getChildren().add((Object)sequenceControlContainer);
        box.getChildren().add((Object)new Label("Range:"));
        box.getChildren().add((Object)rangeControlContainer);
        box.getChildren().add((Object)new Label("Optics:"));
        box.getChildren().add((Object)opticsDefinitionControlContainer);
        SectionPane sectionPane = new SectionPane();
        sectionPane.textProperty().bind((ObservableValue)state.selectedModelDefinitionProperty().asString());
        sectionPane.setContent((Node)box);
        return sectionPane;
    }
}

