/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.domain;

import cern.accsoft.steering.jmad.domain.machine.RangeDefinition;
import cern.accsoft.steering.jmad.domain.machine.SequenceDefinition;
import cern.accsoft.steering.jmad.modeldefs.domain.JMadModelDefinition;
import cern.accsoft.steering.jmad.modeldefs.domain.OpticsDefinition;
import freetimelabs.io.reactorfx.schedulers.FxSchedulers;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import org.jmad.modelpack.domain.ModelPackageVariant;
import org.jmad.modelpack.gui.domain.JMadModelSelectionType;
import org.jmad.modelpack.gui.util.FxUtils;
import org.jmad.modelpack.service.JMadModelPackageService;

public class ModelPackSelectionState {
    private final ObjectProperty<ModelPackageVariant> selectedPackage = new SimpleObjectProperty();
    private final ListProperty<JMadModelDefinition> availableDefinitions = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<JMadModelDefinition> selectedModelDefinition = new SimpleObjectProperty();
    private final ListProperty<OpticsDefinition> availableOptics = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<OpticsDefinition> selectedOptics = new SimpleObjectProperty();
    private final ListProperty<SequenceDefinition> availableSequences = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<SequenceDefinition> selectedSequence = new SimpleObjectProperty();
    private final ListProperty<RangeDefinition> availableRanges = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<RangeDefinition> selectedRange = new SimpleObjectProperty();
    private final ObjectProperty<JMadModelSelectionType> modelSelectionType = new SimpleObjectProperty((Object)JMadModelSelectionType.ALL);
    private final BooleanProperty onlineMode = new SimpleBooleanProperty(true);
    private final BooleanProperty loading = new SimpleBooleanProperty(false);

    public ModelPackSelectionState(JMadModelPackageService modelPackageService) {
        this.selectedPackage.addListener(FxUtils.onChange(newSelectedPackage -> {
            if (newSelectedPackage == null) {
                return;
            }
            modelPackageService.modelDefinitionsFrom(newSelectedPackage).collectList().publishOn(FxSchedulers.fxThread()).doOnSubscribe(s -> this.loading.set(true)).doOnTerminate(() -> this.loading.set(false)).subscribe(defs -> {
                this.availableDefinitions.setAll((Collection)defs);
                if (!defs.isEmpty()) {
                    JMadModelDefinition selectedModelDef = (JMadModelDefinition)defs.get(0);
                    this.updateSelectedModelDefinition(selectedModelDef);
                }
            });
        }));
        this.onlineMode.set(modelPackageService.mode() == JMadModelPackageService.Mode.ONLINE);
        this.onlineMode.addListener(FxUtils.onChange(isOnline -> modelPackageService.setMode(isOnline != false ? JMadModelPackageService.Mode.ONLINE : JMadModelPackageService.Mode.OFFLINE)));
        this.selectedModelDefinition.addListener(FxUtils.onChange(this::updateSelectedModelDefinition));
        this.selectedSequence.addListener(FxUtils.onChange(this::updateSequenceDefinition));
    }

    private void updateSelectedModelDefinition(JMadModelDefinition selectedModelDef) {
        this.selectedModelDefinitionProperty().set((Object)selectedModelDef);
        if (selectedModelDef == null) {
            return;
        }
        this.availableOpticsProperty().setAll((Collection)selectedModelDef.getOpticsDefinitions());
        this.updateOpticsDefinition(selectedModelDef.getDefaultOpticsDefinition());
        this.availableSequencesProperty().setAll((Collection)selectedModelDef.getSequenceDefinitions());
        this.updateSequenceDefinition(selectedModelDef.getDefaultSequenceDefinition());
    }

    private void updateSequenceDefinition(SequenceDefinition sequenceDefinition) {
        this.selectedSequenceProperty().set((Object)sequenceDefinition);
        if (sequenceDefinition != null) {
            this.availableRangesProperty().setAll((Collection)sequenceDefinition.getRangeDefinitions());
            this.selectedRangeProperty().set((Object)sequenceDefinition.getDefaultRangeDefinition());
        }
    }

    private void updateOpticsDefinition(OpticsDefinition opticsDefinition) {
        this.selectedOpticsProperty().set((Object)opticsDefinition);
    }

    public ListProperty<JMadModelDefinition> availableDefinitionsProperty() {
        return this.availableDefinitions;
    }

    public ObjectProperty<ModelPackageVariant> selectedPackageProperty() {
        return this.selectedPackage;
    }

    public ObjectProperty<JMadModelDefinition> selectedModelDefinitionProperty() {
        return this.selectedModelDefinition;
    }

    public ListProperty<OpticsDefinition> availableOpticsProperty() {
        return this.availableOptics;
    }

    public ObjectProperty<OpticsDefinition> selectedOpticsProperty() {
        return this.selectedOptics;
    }

    public ListProperty<SequenceDefinition> availableSequencesProperty() {
        return this.availableSequences;
    }

    public ObjectProperty<SequenceDefinition> selectedSequenceProperty() {
        return this.selectedSequence;
    }

    public ListProperty<RangeDefinition> availableRangesProperty() {
        return this.availableRanges;
    }

    public ObjectProperty<RangeDefinition> selectedRangeProperty() {
        return this.selectedRange;
    }

    public BooleanProperty onlineModeProperty() {
        return this.onlineMode;
    }

    public BooleanProperty loadingProperty() {
        return this.loading;
    }

    public ObjectProperty<JMadModelSelectionType> modelSelectionTypeProperty() {
        return this.modelSelectionType;
    }
}

