/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.dialogs;

import cern.accsoft.steering.jmad.domain.machine.RangeDefinition;
import cern.accsoft.steering.jmad.model.JMadModelStartupConfiguration;
import cern.accsoft.steering.jmad.modeldefs.domain.JMadModelDefinition;
import cern.accsoft.steering.jmad.modeldefs.domain.OpticsDefinition;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Region;
import org.jmad.modelpack.gui.domain.JMadModelSelection;
import org.jmad.modelpack.gui.domain.JMadModelSelectionType;
import org.jmad.modelpack.gui.domain.ModelPackSelectionState;
import org.jmad.modelpack.gui.util.GuiUtils;

public class JMadModelSelectionDialog
extends Dialog<JMadModelSelection> {
    private final ModelPackSelectionState selectionState;

    public JMadModelSelectionDialog(Region modelSelectionRegion, Region repositorySelectionRegion, ModelPackSelectionState selectionState) {
        this.selectionState = selectionState;
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabPane.getTabs().add((Object)new Tab("Available models", (Node)modelSelectionRegion));
        tabPane.getTabs().add((Object)new Tab("Models repositories", (Node)repositorySelectionRegion));
        tabPane.setPrefWidth(1000.0);
        tabPane.setPrefHeight(700.0);
        this.getDialogPane().setContent((Node)tabPane);
        ButtonType buttonTypeOk = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        this.setTitle("JMad Model Selection");
        this.getDialogPane().setPadding(GuiUtils.ZERO_INSETS);
        tabPane.setPadding(GuiUtils.ZERO_INSETS);
        this.setResultConverter(b -> {
            if (b != buttonTypeOk) {
                return null;
            }
            JMadModelDefinition modelDefinition = (JMadModelDefinition)selectionState.selectedModelDefinitionProperty().get();
            if (modelDefinition == null) {
                return null;
            }
            if (selectionState.modelSelectionTypeProperty().get() == JMadModelSelectionType.MODEL_DEFINITION_ONLY) {
                return new JMadModelSelection(modelDefinition);
            }
            if (selectionState.modelSelectionTypeProperty().get() == JMadModelSelectionType.ALL) {
                OpticsDefinition opticsDefinition = (OpticsDefinition)selectionState.selectedOpticsProperty().get();
                RangeDefinition rangeDefinition = (RangeDefinition)selectionState.selectedRangeProperty().get();
                JMadModelStartupConfiguration startupConfiguration = new JMadModelStartupConfiguration();
                startupConfiguration.setInitialOpticsDefinition(opticsDefinition);
                startupConfiguration.setInitialRangeDefinition(rangeDefinition);
                return new JMadModelSelection(modelDefinition, startupConfiguration);
            }
            throw new IllegalStateException("Invalid model selection type");
        });
    }

    public void setModelSelectionType(JMadModelSelectionType type) {
        this.selectionState.modelSelectionTypeProperty().set((Object)type);
    }
}

