/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.conf;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jmad.modelpack.gui.dialogs.JMadModelSelectionDialog;
import org.jmad.modelpack.gui.domain.JMadModelSelection;
import org.jmad.modelpack.gui.domain.JMadModelSelectionType;
import org.jmad.modelpack.gui.util.FxUtils;
import org.springframework.beans.factory.annotation.Lookup;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="jmadModelSelectionDialogFactory")
@Lazy
public class JMadModelSelectionDialogFactory {
    private static final int MODELPACK_DIALOG_WIDTH = 1000;
    private static final int MODELPACK_DIALOG_HEIGHT = 700;

    public Optional<JMadModelSelection> showAndWaitModelSelection() {
        return this.showAndWaitModelSelection(JMadModelSelectionType.ALL);
    }

    public Optional<JMadModelSelection> showAndWaitModelSelection(JMadModelSelectionType selectionType) {
        AtomicReference userSelection = new AtomicReference();
        FxUtils.runSyncOnFxThread(() -> {
            JMadModelSelectionDialog selectionDialog = this.jmadModelSelectionDialog();
            selectionDialog.setModelSelectionType(selectionType);
            selectionDialog.setWidth(1000.0);
            selectionDialog.setHeight(700.0);
            userSelection.set(selectionDialog.showAndWait());
        });
        return (Optional)userSelection.get();
    }

    @Lookup
    protected JMadModelSelectionDialog jmadModelSelectionDialog() {
        return null;
    }
}

