/*
 * Decompiled with CFR 0.152.
 */
package org.jmad.modelpack.gui.conf;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import org.jmad.modelpack.gui.dialogs.JMadModelSelectionDialog;
import org.jmad.modelpack.gui.domain.ModelPackSelectionState;
import org.jmad.modelpack.gui.panes.JMadModelDefinitionSelectionControl;
import org.jmad.modelpack.gui.panes.JMadModelPackagesSelectionControl;
import org.jmad.modelpack.gui.panes.JMadModelRepositorySelectionControl;
import org.jmad.modelpack.gui.util.GuiUtils;
import org.jmad.modelpack.service.JMadModelPackageRepositoryManager;
import org.jmad.modelpack.service.JMadModelPackageService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ComponentScan(basePackageClasses={JMadModelSelectionDialogConfiguration.class})
public class JMadModelSelectionDialogConfiguration {
    @Bean
    @Lazy
    public JMadModelSelectionDialog jmadModelSelectionDialog(Region modelSelectionRegion, Region repositorySelectionControl, ModelPackSelectionState selectionState) {
        JMadModelSelectionDialog dialog = new JMadModelSelectionDialog(modelSelectionRegion, repositorySelectionControl, selectionState);
        dialog.setResizable(true);
        dialog.initModality(Modality.NONE);
        return dialog;
    }

    @Bean
    @Lazy
    public JMadModelPackagesSelectionControl packagesSelectionControl(JMadModelPackageService packageService, ModelPackSelectionState modelPackSelectionState) {
        return new JMadModelPackagesSelectionControl(packageService, modelPackSelectionState);
    }

    @Bean
    @Lazy
    public JMadModelDefinitionSelectionControl definitionSelectionControl(ModelPackSelectionState modelPackSelectionState) {
        return new JMadModelDefinitionSelectionControl(modelPackSelectionState);
    }

    @Bean
    @Lazy
    public Region modelSelectionRegion(JMadModelPackagesSelectionControl packagesSelectionControl, JMadModelDefinitionSelectionControl definitionSelectionControl) {
        HBox pane = new HBox(new Node[]{packagesSelectionControl, definitionSelectionControl});
        pane.setFillHeight(true);
        pane.setPadding(GuiUtils.DEFAULT_SPACING_INSETS);
        pane.setSpacing(8.0);
        pane.setAlignment(Pos.TOP_CENTER);
        pane.setFillHeight(true);
        HBox.setHgrow((Node)packagesSelectionControl, (Priority)Priority.ALWAYS);
        return pane;
    }

    @Bean
    @Lazy
    public ModelPackSelectionState modelPackSelectionState(JMadModelPackageService packageService) {
        return new ModelPackSelectionState(packageService);
    }

    @Bean
    @Lazy
    public JMadModelRepositorySelectionControl repositorySelectionControl(JMadModelPackageRepositoryManager manager) {
        return new JMadModelRepositorySelectionControl(manager);
    }
}

