/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.script;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class JConsole
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private boolean output_able;
    private SimpleAttributeSet out_att;
    private SimpleAttributeSet err_att;
    private ConsoleOutputStream out;
    private ConsoleOutputStream err;
    private StyledDocument text;

    public JConsole() {
        this.setEditable(false);
        this.setBackground(Color.BLACK);
        this.out_att = new SimpleAttributeSet();
        StyleConstants.setForeground(this.out_att, Color.GREEN);
        this.err_att = new SimpleAttributeSet();
        StyleConstants.setForeground(this.err_att, Color.RED);
        this.text = new DefaultStyledDocument();
        this.setDocument(this.text);
        this.out = new ConsoleOutputStream();
        this.err = new ConsoleOutputStream();
        this.output_able = true;
    }

    private synchronized void print(byte[] b, ConsoleOutputStream os) {
        try {
            this.text.insertString(this.text.getLength(), new String(b, 0, b.length), os == this.out ? this.out_att : this.err_att);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void clear() throws BadLocationException {
        this.text.remove(0, this.text.getLength());
    }

    public void redirectSystem() {
        System.setOut(new PrintStream(this.out, true));
        System.setErr(new PrintStream(this.err, true));
    }

    public void setOutColor(Color outc) {
        StyleConstants.setForeground(this.out_att, outc);
    }

    public void setErrColor(Color errc) {
        StyleConstants.setForeground(this.err_att, errc);
    }

    public OutputStream getOutStream() {
        return this.out;
    }

    public OutputStream getErrStream() {
        return this.err;
    }

    private class ConsoleOutputStream
    extends OutputStream {
        private Queue<Byte> buffer = new LinkedList<Byte>();
        private boolean closed = false;

        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.buffer.offer((byte)b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            if (JConsole.this.output_able) {
                Queue<Byte> queue = this.buffer;
                synchronized (queue) {
                    byte[] b = new byte[this.buffer.size()];
                    int cnt = 0;
                    while (!this.buffer.isEmpty()) {
                        b[cnt++] = this.buffer.poll();
                    }
                    JConsole.this.print(b, this);
                }
            }
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

