/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.table.TableRowSorter;

public class TableFilterPanel
extends JPanel {
    private static final long serialVersionUID = -1378930333245172769L;
    private final JTable table;
    private final String initialExpression;

    public TableFilterPanel(JTable table) {
        this(table, null);
    }

    public TableFilterPanel(JTable table, String initialExpression) {
        this.table = table;
        this.initialExpression = initialExpression;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        this.add((Component)new JLabel("Filter:"), constraints);
        this.table.setAutoCreateRowSorter(true);
        final TableRowSorter elementsSorter = (TableRowSorter)this.table.getRowSorter();
        final JTextField filterText = new JTextField();
        if (this.initialExpression != null) {
            filterText.setText(this.initialExpression);
            elementsSorter.setRowFilter(RowFilter.regexFilter(this.initialExpression, new int[0]));
        }
        filterText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String text = filterText.getText();
                if (text.length() == 0) {
                    elementsSorter.setRowFilter(null);
                } else {
                    elementsSorter.setRowFilter(RowFilter.regexFilter(text, new int[0]));
                }
            }
        });
        constraints.weightx = 1.0;
        ++constraints.gridx;
        this.add((Component)filterText, constraints);
    }
}

