/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.menu;

import cern.accsoft.steering.util.gui.AskUtils;
import cern.accsoft.steering.util.gui.menu.ActionProvider;
import cern.accsoft.steering.util.gui.menu.Checkable;
import cern.accsoft.steering.util.gui.menu.ValueSetable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class TablePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -3519304791315763524L;
    private Checkable checkable = null;
    private ValueSetable valueSetable = null;
    private ActionProvider actionProvider = null;
    private JMenuItem itemSetValue = null;
    private JMenuItem itemCheck = null;
    private JMenuItem itemUncheck = null;

    public TablePopupMenu(Object object) {
        if (object instanceof Checkable) {
            this.checkable = (Checkable)object;
        }
        if (object instanceof ValueSetable) {
            this.valueSetable = (ValueSetable)object;
        }
        if (object instanceof ActionProvider) {
            this.actionProvider = (ActionProvider)object;
        }
        this.initComponents();
    }

    private void initComponents() {
        if (this.valueSetable != null) {
            this.itemSetValue = new JMenuItem("set " + this.valueSetable.getValueName());
            this.itemSetValue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Double value;
                    if (TablePopupMenu.this.valueSetable != null && (value = AskUtils.askDouble("Set " + TablePopupMenu.this.valueSetable.getValueName() + " for selected rows: ", 0.0)) != null) {
                        TablePopupMenu.this.valueSetable.setValueAllSelected(value);
                    }
                }
            });
            this.add(this.itemSetValue);
            this.addSeparator();
        }
        if (this.checkable != null) {
            this.itemCheck = new JMenuItem("check");
            this.itemCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TablePopupMenu.this.checkable != null) {
                        TablePopupMenu.this.checkable.checkAllSelected();
                    }
                }
            });
            this.add(this.itemCheck);
            this.itemUncheck = new JMenuItem("uncheck");
            this.itemUncheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (TablePopupMenu.this.checkable != null) {
                        TablePopupMenu.this.checkable.uncheckAllSelected();
                    }
                }
            });
            this.add(this.itemUncheck);
            this.addSeparator();
        }
        if (this.actionProvider != null) {
            for (Action action : this.actionProvider.getActions()) {
                JMenuItem item = new JMenuItem(action);
                this.add(item);
            }
        }
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (this.valueSetable != null) {
            this.itemSetValue.setEnabled(this.valueSetable.isValueSetEnabled());
        }
        if (this.checkable != null) {
            this.itemCheck.setEnabled(this.checkable.isCheckUncheckEnabled());
            this.itemUncheck.setEnabled(this.checkable.isCheckUncheckEnabled());
        }
        super.show(invoker, x, y);
    }
}

