/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.domain.machine.Range;
import cern.accsoft.steering.jmad.domain.twiss.TwissInitialConditions;
import cern.accsoft.steering.jmad.domain.twiss.TwissListener;
import cern.accsoft.steering.jmad.gui.panels.EditHandlerUser;
import cern.accsoft.steering.jmad.gui.panels.TablePanelEditHandler;
import cern.accsoft.steering.jmad.model.AbstractJMadModelListener;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.JMadModelListener;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import cern.accsoft.steering.util.gui.table.BeanTableEditHandler;
import cern.accsoft.steering.util.gui.table.BeanTableModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ModelTwissPanel
extends JPanel
implements EditHandlerUser<BeanTableEditHandler> {
    private static final long serialVersionUID = 7182385328020991187L;
    private JMadModelManager modelManager;
    private BeanTableModel doubleTableModel = new BeanTableModel(TwissInitialConditions.class);
    private BeanTableModel booleanTableModel = new BeanTableModel(TwissInitialConditions.class);
    private JMadModel model;
    private JMadModelListener modelListener = new AbstractJMadModelListener(){

        public void rangeChanged(Range newRange) {
            ModelTwissPanel.this.refreshTwiss();
        }
    };
    private TwissListener twissListener = new TwissListener(){

        public void changedTwiss(TwissInitialConditions twiss) {
            ModelTwissPanel.this.doubleTableModel.fireTableDataChanged();
            ModelTwissPanel.this.booleanTableModel.fireTableDataChanged();
        }
    };

    public ModelTwissPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 4.0;
        constraints.fill = 1;
        this.doubleTableModel.setEditable(true);
        JTable table = new JTable(this.doubleTableModel);
        this.add((Component)this.createScrollPane(table), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.booleanTableModel.setEditable(true);
        this.booleanTableModel.setValueClasses(new Class[]{Boolean.class, Boolean.TYPE});
        table = new JTable(this.booleanTableModel);
        this.add((Component)this.createScrollPane(table), constraints);
    }

    private JScrollPane createScrollPane(Component component) {
        return new JScrollPane(component, 20, 30);
    }

    private void setModel(JMadModel model) {
        if (model == null) {
            return;
        }
        this.model = model;
        model.addListener(this.modelListener);
        this.refreshTwiss();
    }

    private void refreshTwiss() {
        TwissInitialConditions twiss = this.model.getTwissInitialConditions();
        twiss.addListener(this.twissListener);
        this.doubleTableModel.setBean(twiss);
        this.doubleTableModel.fireTableDataChanged();
        this.booleanTableModel.setBean(twiss);
        this.booleanTableModel.fireTableDataChanged();
    }

    public void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
        this.setModel(this.modelManager.getActiveModel());
        this.modelManager.addListener((JMadModelManagerListener)new JMadModelManagerAdapter(){

            public void changedActiveModel(JMadModel newModel) {
                ModelTwissPanel.this.setModel(newModel);
            }
        });
    }

    @Override
    public void setEditHandler(TablePanelEditHandler editHandler) {
        if (editHandler instanceof BeanTableEditHandler) {
            this.doubleTableModel.setEditHandler((BeanTableEditHandler)editHandler);
        }
    }
}

