/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.dv.ds;

import cern.accsoft.steering.util.gui.dv.ds.AccurateCoordinatesPane;
import cern.accsoft.steering.util.gui.dv.ds.AlohaSineFitInteractor;
import cern.accsoft.steering.util.gui.dv.ds.TwoPointChartRenderer;
import cern.accsoft.steering.util.gui.dv.ds.ValidityRenderingHint;
import cern.jdve.Chart;
import cern.jdve.ChartDecoration;
import cern.jdve.ChartInteractor;
import cern.jdve.ChartRenderer;
import cern.jdve.InteractorsToolbar;
import cern.jdve.LabelRenderer;
import cern.jdve.data.DataSet;
import cern.jdve.graphic.ChartAnnotation;
import cern.jdve.graphic.MarkerFactory;
import cern.jdve.graphic.RenderingHint;
import cern.jdve.interactor.CoordinatesPane;
import cern.jdve.interactor.DataPickerInteractor;
import cern.jdve.interactor.ScrollInteractor;
import cern.jdve.interactor.ZoomInteractor;
import cern.jdve.renderer.BarChartRenderer;
import cern.jdve.renderer.HiLoRenderer;
import cern.jdve.renderer.PolylineChartRenderer;
import cern.jdve.renderer.ScatterChartRenderer;
import cern.jdve.viewer.DataView;
import java.awt.Component;
import java.awt.Font;

public final class DvUtils {
    public static final RenderingHint VALIDITY_RENDERING_HINT = new ValidityRenderingHint();

    private DvUtils() {
    }

    public static final DataView createFitInteractorView(Chart chart) {
        chart.setInteractors(ChartInteractor.createEditIteractors());
        ChartInteractor interactor = chart.getInteractorOfType(207);
        if (interactor != null && interactor instanceof DataPickerInteractor) {
            DvUtils.configureDataPickerInteractor((DataPickerInteractor)interactor);
        }
        AlohaSineFitInteractor sineFitInteractor = new AlohaSineFitInteractor();
        chart.addInteractor((ChartInteractor)sineFitInteractor);
        DataView dataView = new DataView(chart);
        InteractorsToolbar toolBar = chart.getInteractorsToolbar();
        toolBar.addSeparator();
        Component[] fitComponents = sineFitInteractor.getToolBarComponents();
        for (int i = 0; i < fitComponents.length; ++i) {
            toolBar.add(fitComponents[i]);
        }
        dataView.add((Component)toolBar, (Object)"North");
        return dataView;
    }

    public static final DataView createDataView(Chart chart) {
        return new DataView(chart);
    }

    public static final ChartRenderer createPolylineRenderer(DataSet dataSet) {
        ChartRenderer renderer = DvUtils.createMarkerPolylineRenderer();
        renderer.setDataSet(dataSet);
        return renderer;
    }

    public static final ChartRenderer createMarkerPolylineRenderer() {
        PolylineChartRenderer renderer = new PolylineChartRenderer(MarkerFactory.getMarker((int)2));
        renderer.setMarkerSize(4);
        DvUtils.configureRenderer((ChartRenderer)renderer);
        return renderer;
    }

    public static final ChartRenderer createScatterRenderer() {
        ScatterChartRenderer renderer = new ScatterChartRenderer(MarkerFactory.getMarker((int)2), 4);
        DvUtils.configureRenderer((ChartRenderer)renderer);
        return renderer;
    }

    public static final ChartRenderer createTwoPointRenderer() {
        TwoPointChartRenderer renderer = new TwoPointChartRenderer(MarkerFactory.getMarker((int)2), 5);
        DvUtils.configureRenderer((ChartRenderer)renderer);
        return renderer;
    }

    public static final ChartRenderer createPolyLineRenderer() {
        PolylineChartRenderer renderer = new PolylineChartRenderer();
        DvUtils.configureRenderer((ChartRenderer)renderer);
        return renderer;
    }

    public static final ChartRenderer createHiLoRenderer() {
        HiLoRenderer renderer = new HiLoRenderer();
        DvUtils.configureRenderer((ChartRenderer)renderer);
        return renderer;
    }

    public static final ChartRenderer createBarChartRenderer() {
        BarChartRenderer renderer = new BarChartRenderer();
        DvUtils.configureRenderer((ChartRenderer)renderer);
        return renderer;
    }

    private static final void configureRenderer(ChartRenderer renderer) {
        renderer.setRenderingHint(VALIDITY_RENDERING_HINT);
    }

    public static final ChartInteractor createDataPickerInteractor() {
        DataPickerInteractor dataPicker = new DataPickerInteractor();
        DvUtils.configureDataPickerInteractor(dataPicker);
        return dataPicker;
    }

    public static final void configureDefaultInteractors(Chart chart) {
        chart.addInteractor(DvUtils.createDataPickerInteractor());
        chart.addInteractor((ChartInteractor)new ZoomInteractor());
        chart.addInteractor((ChartInteractor)new ScrollInteractor());
    }

    private static final void configureDataPickerInteractor(DataPickerInteractor dataPicker) {
        dataPicker.setPointCoordPane((CoordinatesPane)new AccurateCoordinatesPane());
        dataPicker.setDisplayDataSetName(false);
        dataPicker.setCursorCoordPainted(false);
        dataPicker.getPointCoordPane().setXCoordDisplay(1);
    }

    public static final ChartAnnotation addComment(Chart chart, String comment) {
        ChartAnnotation commentAnnotation = new ChartAnnotation(comment, 5.0, 1.0, false);
        LabelRenderer labRender = new LabelRenderer();
        labRender.setFont(new Font("Monospaced", 1, 12));
        labRender.setHorizontalAlignment(2);
        labRender.setVerticalAlignment(1);
        labRender.setBackground(null);
        labRender.setBorder(null);
        commentAnnotation.setLabelRenderer(labRender);
        chart.addDecoration((ChartDecoration)commentAnnotation);
        return commentAnnotation;
    }
}

