/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels.elements;

import cern.accsoft.steering.jmad.domain.elem.Element;
import cern.accsoft.steering.jmad.domain.ex.JMadModelException;
import cern.accsoft.steering.jmad.domain.optics.OpticPoint;
import cern.accsoft.steering.jmad.domain.types.enums.JMadPlane;
import cern.accsoft.steering.jmad.gui.dv.ChartFactory;
import cern.accsoft.steering.jmad.gui.manage.ElementSelectionManager;
import cern.accsoft.steering.jmad.gui.manage.ElementSelectionManagerListener;
import cern.accsoft.steering.jmad.gui.panels.elements.PhaseSpaceDataSet;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.jdve.Chart;
import cern.jdve.data.DataSet;
import cern.jdve.data.DataSource;
import cern.jdve.data.DefaultDataSource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class PhaseSpacePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ElementSelectionManager elementSelectionManager;
    private ChartFactory chartFactory;
    private JMadModelManager modelManager;
    private List<PhaseSpaceDataSet> dataSets = new ArrayList<PhaseSpaceDataSet>();

    public void init() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        Chart chart = this.createChart(JMadPlane.H);
        this.add((Component)chart, constraints);
        ++constraints.gridx;
        chart = this.createChart(JMadPlane.V);
        this.add((Component)chart, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 0.0;
        final JCheckBox chkNormalized = new JCheckBox("Normalized");
        chkNormalized.setSelected(this.dataSets.get(0).isNormalized());
        chkNormalized.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean normalized = chkNormalized.isSelected();
                for (PhaseSpaceDataSet dataSet : PhaseSpacePanel.this.dataSets) {
                    dataSet.setNormalized(normalized);
                }
            }
        });
        this.add((Component)chkNormalized, constraints);
    }

    private Chart createChart(JMadPlane plane) {
        PhaseSpaceDataSet dataSet = new PhaseSpaceDataSet("Phase Space " + plane.toString(), plane);
        this.dataSets.add(dataSet);
        DefaultDataSource dataSource = new DefaultDataSource((DataSet)dataSet);
        Chart chart = new Chart();
        this.getChartFactory().configurePolylineChart((DataSource)dataSource, chart);
        return chart;
    }

    public void setElementSelectionManager(ElementSelectionManager elementSelectionManager) {
        this.elementSelectionManager = elementSelectionManager;
        this.elementSelectionManager.addListener(new ElementSelectionManagerListener(){

            @Override
            public void changedSelectedElements(List<Element> selectedElements, Element lastSelectedElement) {
                PhaseSpacePanel.this.updateOpticsPoints(selectedElements);
            }
        });
    }

    private void updateOpticsPoints(List<Element> selectedElements) {
        List<OpticPoint> opticsPoints = this.getElementOptics(selectedElements);
        for (PhaseSpaceDataSet dataSet : this.dataSets) {
            dataSet.setOpticsPoints(opticsPoints);
        }
    }

    private List<OpticPoint> getElementOptics(List<Element> elements) {
        ArrayList<OpticPoint> opticsPoints = new ArrayList<OpticPoint>();
        JMadModel model = this.getModelManager().getActiveModel();
        for (Element element : elements) {
            OpticPoint opticPoint = null;
            try {
                opticPoint = model.getOptics().getPoint(element);
            }
            catch (JMadModelException jMadModelException) {
                // empty catch block
            }
            if (opticPoint == null) continue;
            opticsPoints.add(opticPoint);
        }
        return opticsPoints;
    }

    public void setChartFactory(ChartFactory chartFactory) {
        this.chartFactory = chartFactory;
    }

    private ChartFactory getChartFactory() {
        return this.chartFactory;
    }

    public void setModelManager(JMadModelManager modelManager) {
        this.modelManager = modelManager;
    }

    private JMadModelManager getModelManager() {
        return this.modelManager;
    }
}

