/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.manage.impl;

import cern.accsoft.steering.jmad.domain.var.custom.CustomVariable;
import cern.accsoft.steering.jmad.domain.var.custom.StrengthVarSet;
import cern.accsoft.steering.jmad.domain.var.custom.StrengthVarSetImpl;
import cern.accsoft.steering.jmad.gui.manage.StrengthVarManager;
import cern.accsoft.steering.jmad.gui.manage.StrengthVarManagerListener;
import cern.accsoft.steering.jmad.io.StrengthFileParserException;
import cern.accsoft.steering.jmad.io.StrengthFileParserNew;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class StrengthVarManagerImpl
implements StrengthVarManager {
    private static final Logger logger = Logger.getLogger(StrengthVarManagerImpl.class);
    private StrengthVarSet strengthVarSet = new StrengthVarSetImpl();
    private List<StrengthVarManagerListener> listeners = new ArrayList<StrengthVarManagerListener>();

    @Override
    public StrengthVarSet getStrengthVarSet() {
        return this.strengthVarSet;
    }

    @Override
    public void load(File file) {
        if (file == null) {
            logger.error((Object)"File is null! Nothing to parse.");
            return;
        }
        StrengthFileParserNew parser = new StrengthFileParserNew(file);
        try {
            parser.parse();
        }
        catch (StrengthFileParserException e) {
            logger.error((Object)("Could not parse file '" + file.getAbsolutePath() + "'."), (Throwable)e);
            return;
        }
        this.strengthVarSet.addAllStrengths((Collection)parser.getStrengths());
        this.strengthVarSet.addAllVariables((Collection)parser.getVariables());
        this.fireChangedVariables();
    }

    private void fireChangedVariables() {
        for (StrengthVarManagerListener listener : this.listeners) {
            listener.changedVariables(new ArrayList<CustomVariable>(this.strengthVarSet.getVariables()));
        }
    }

    @Override
    public void addListener(StrengthVarManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(StrengthVarManagerListener listener) {
        this.listeners.remove(listener);
    }
}

