/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.util.gui.dv.ds;

import Jama.Matrix;
import cern.accsoft.steering.util.gui.dv.ds.ValidityMatrixDataSet;
import java.util.List;

public abstract class MatrixRowColDataSet
extends ValidityMatrixDataSet {
    private Matrix matrix = new Matrix(1, 1);
    private Matrix offsetMatrix;
    private boolean offsetSubtract = false;
    private final MatrixDsType type;
    private int fixedIndex = 0;
    private Integer firstIndex = null;
    private Integer lastIndex = null;

    public MatrixRowColDataSet(MatrixDsType type, String name) {
        super(name);
        this.type = type;
    }

    private RowCol getRowCol(int index) {
        int idx = index;
        if (this.firstIndex != null) {
            idx += this.firstIndex.intValue();
        }
        if (MatrixDsType.ROW.equals((Object)this.type)) {
            return new RowCol(this.getFixedIndex(), idx);
        }
        if (MatrixDsType.COLUMN.equals((Object)this.type)) {
            return new RowCol(idx, this.getFixedIndex());
        }
        return null;
    }

    public int getDataCount() {
        int first = 0;
        if (this.firstIndex != null) {
            first = this.firstIndex;
        }
        int last = 0;
        if (this.lastIndex == null) {
            if (this.matrix != null) {
                if (MatrixDsType.ROW.equals((Object)this.type)) {
                    last = this.matrix.getColumnDimension();
                } else if (MatrixDsType.COLUMN.equals((Object)this.type)) {
                    last = this.matrix.getRowDimension();
                }
            }
        } else {
            last = this.lastIndex;
        }
        return last - first;
    }

    public final MatrixDsType getType() {
        return this.type;
    }

    public double getY(int index) {
        RowCol rowCol = this.getRowCol(index);
        double value = MatrixRowColDataSet.getMatrixValue(this.matrix, rowCol);
        double offset = MatrixRowColDataSet.getMatrixValue(this.offsetMatrix, rowCol);
        if (this.isOffsetSubtract()) {
            return value - offset;
        }
        return value + offset;
    }

    private static final double getMatrixValue(Matrix m, RowCol rowCol) {
        if (rowCol != null && m != null && rowCol.row < m.getRowDimension() && rowCol.col < m.getColumnDimension()) {
            return m.get(rowCol.row, rowCol.col);
        }
        return 0.0;
    }

    @Override
    public boolean getValidity(int index) {
        RowCol rowCol = this.getRowCol(index);
        if (rowCol != null) {
            return this.getValidity(rowCol.row, rowCol.col);
        }
        return false;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
        this.fireFullChange();
    }

    public void setMatrix(Matrix matrix, List<Double> xValues) {
        super.setXValues(xValues);
        this.matrix = matrix;
        this.fireFullChange();
    }

    public void setFixedIndex(int fixedIndex) {
        this.fixedIndex = fixedIndex;
        this.fireFullChange();
    }

    public int getFixedIndex() {
        return this.fixedIndex;
    }

    public void setOffsetMatrix(Matrix offsetMatrix) {
        this.offsetMatrix = offsetMatrix;
        this.fireFullChange();
    }

    public Matrix getOffsetMatrix() {
        return this.offsetMatrix;
    }

    public void setOffsetSubtract(boolean offsetSubtract) {
        this.offsetSubtract = offsetSubtract;
        this.fireFullChange();
    }

    public boolean isOffsetSubtract() {
        return this.offsetSubtract;
    }

    public void setFirstIndex(Integer firstIndex) {
        this.firstIndex = firstIndex;
        this.fireFullChange();
    }

    public Integer getFirstIndex() {
        return this.firstIndex;
    }

    public void setLastIndex(Integer lastIndex) {
        this.lastIndex = lastIndex;
        this.fireFullChange();
    }

    public Integer getLastIndex() {
        return this.lastIndex;
    }

    public static enum MatrixDsType {
        ROW,
        COLUMN;

    }

    private class RowCol {
        private final int row;
        private final int col;

        private RowCol(int row, int col) {
            this.row = row;
            this.col = col;
        }
    }
}

