/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels.var;

import cern.accsoft.steering.jmad.domain.var.TwissVariable;
import cern.accsoft.steering.jmad.gui.panels.var.SelectedVarManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectedVarManagerImpl
implements SelectedVarManager {
    private static final Logger logger = LoggerFactory.getLogger(SelectedVarManagerImpl.class);
    private SelectedVarManager.VarSelectionMode varSelectionMode = SelectedVarManager.VarSelectionMode.MULTIPLE;
    private List<TwissVariable> variables = new ArrayList<TwissVariable>();

    @Override
    public void add(TwissVariable twissVariable) {
        if (SelectedVarManager.VarSelectionMode.SINGLE == this.varSelectionMode) {
            this.clear();
        }
        this.variables.add(twissVariable);
    }

    @Override
    public void clear() {
        this.variables.clear();
    }

    @Override
    public Collection<TwissVariable> getSelectedVariables() {
        return this.variables;
    }

    @Override
    public void remove(TwissVariable twissVariable) {
        if (SelectedVarManager.VarSelectionMode.SINGLE == this.varSelectionMode) {
            return;
        }
        this.variables.remove(twissVariable);
    }

    @Override
    public void setVarSelectionMode(SelectedVarManager.VarSelectionMode varSelectionMode) {
        this.varSelectionMode = varSelectionMode;
    }

    @Override
    public TwissVariable getSelectedVariable() {
        if (SelectedVarManager.VarSelectionMode.SINGLE != this.varSelectionMode) {
            logger.warn("This only makes sense in single selection mode!");
            return null;
        }
        if (this.variables.size() == 1) {
            return this.variables.get(0);
        }
        return null;
    }

    @Override
    public SelectedVarManager.VarSelectionMode getVarSelectionMode() {
        return this.varSelectionMode;
    }
}

