/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.panels;

import cern.accsoft.steering.jmad.domain.knob.Knob;
import cern.accsoft.steering.jmad.gui.components.DoubleTableCellRenderer;
import cern.accsoft.steering.jmad.gui.panels.EditHandlerUser;
import cern.accsoft.steering.jmad.gui.panels.KnobsPanelEditHandler;
import cern.accsoft.steering.jmad.gui.panels.TablePanelEditHandler;
import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.JMadModelListener;
import cern.accsoft.steering.jmad.model.manage.JMadModelManager;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerAdapter;
import cern.accsoft.steering.jmad.model.manage.JMadModelManagerListener;
import cern.accsoft.steering.jmad.model.manage.StrengthVarManagerListener;
import cern.accsoft.steering.util.gui.menu.ActionProvider;
import cern.accsoft.steering.util.gui.menu.Checkable;
import cern.accsoft.steering.util.gui.menu.MousePopupListener;
import cern.accsoft.steering.util.gui.menu.TablePopupMenu;
import cern.accsoft.steering.util.gui.menu.ValueSetable;
import cern.accsoft.steering.util.gui.panels.TableFilterPanel;
import cern.accsoft.steering.util.gui.table.SelectionSetTableModel;
import cern.accsoft.steering.util.gui.table.TableModelSelectionAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public abstract class AbstractKnobsPanel
extends JPanel
implements EditHandlerUser<KnobsPanelEditHandler> {
    private static final long serialVersionUID = 1733380183463632497L;
    private KnobsPanelEditHandler editHandler;
    private ModelStrengthesTableModel tableModel;
    private JMadModel model;
    private ActionProvider actionProvider;

    public AbstractKnobsPanel() {
        super(new BorderLayout());
    }

    public void init() {
        this.initComponents();
        if (this.model != null) {
            this.refreshDisplay();
        }
    }

    @Override
    public void setEditHandler(TablePanelEditHandler editHandler) {
        if (editHandler instanceof KnobsPanelEditHandler) {
            this.editHandler = (KnobsPanelEditHandler)editHandler;
        }
    }

    public void setModelManager(JMadModelManager modelManager) {
        modelManager.addListener((JMadModelManagerListener)new JMadModelManagerAdapter(){

            public void changedActiveModel(JMadModel newModel) {
                AbstractKnobsPanel.this.setModel(newModel);
                AbstractKnobsPanel.this.refreshDisplay();
            }
        });
        if (modelManager.getActiveModel() != null) {
            this.setModel(modelManager.getActiveModel());
        }
    }

    protected void refreshDisplay() {
        if (this.tableModel != null) {
            this.tableModel.fireTableDataChanged();
        }
    }

    private void initComponents() {
        this.tableModel = new ModelStrengthesTableModel();
        JTable table = new JTable(this.tableModel);
        table.setDefaultRenderer(Double.class, new DoubleTableCellRenderer());
        table.setAutoCreateRowSorter(true);
        table.getSelectionModel().setSelectionMode(2);
        new MousePopupListener(table, new TablePopupMenu(this.tableModel));
        this.tableModel.setTableModelSelectionAdapter(new TableModelSelectionAdapter(table));
        JScrollPane scrollPane = new JScrollPane(table, 20, 30);
        this.add((Component)new TableFilterPanel(table), "North");
        this.add((Component)scrollPane, "Center");
    }

    public abstract List<? extends Knob> getKnobs();

    protected abstract JMadModelListener getModelListener();

    protected abstract StrengthVarManagerListener getStrengthVarManagerListener();

    private void setModel(JMadModel model) {
        this.model = model;
        if (model != null) {
            StrengthVarManagerListener strengthVarManagerListener;
            JMadModelListener listener = this.getModelListener();
            if (listener != null) {
                model.addListener(listener);
            }
            if ((strengthVarManagerListener = this.getStrengthVarManagerListener()) != null) {
                model.getStrengthVarManager().addListener(strengthVarManagerListener);
            }
        }
    }

    protected JMadModel getModel() {
        return this.model;
    }

    public SelectionSetTableModel getTableModel() {
        return this.tableModel;
    }

    public void setActionProvider(ActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    public ActionProvider getActionProvider() {
        return this.actionProvider;
    }

    class ModelStrengthesTableModel
    extends SelectionSetTableModel
    implements ValueSetable,
    Checkable,
    ActionProvider {
        private static final int COLUMN_COUNT = 4;
        private static final int COL_SELECT = 0;
        private static final int COL_NAME = 1;
        private static final int COL_VALUE = 2;
        private static final int COL_COMMENT = 3;
        private static final long serialVersionUID = 1L;

        ModelStrengthesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            List<? extends Knob> knobs = AbstractKnobsPanel.this.getKnobs();
            if (knobs != null) {
                return knobs.size();
            }
            return 0;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return AbstractKnobsPanel.this.editHandler != null;
            }
            return col == 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            List<? extends Knob> knobs = AbstractKnobsPanel.this.getKnobs();
            if (knobs == null) {
                return null;
            }
            Knob knob = knobs.get(row);
            switch (col) {
                case 0: {
                    if (AbstractKnobsPanel.this.editHandler != null) {
                        return AbstractKnobsPanel.this.editHandler.getSelectionValue(knob);
                    }
                    return false;
                }
                case 1: {
                    return knob.getName();
                }
                case 2: {
                    return knob.getValue();
                }
                case 3: {
                    return knob.getDescription();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            List<? extends Knob> knobs = AbstractKnobsPanel.this.getKnobs();
            if (knobs == null) {
                return;
            }
            Knob modelValue = knobs.get(row);
            switch (col) {
                case 0: {
                    if (AbstractKnobsPanel.this.editHandler == null) break;
                    AbstractKnobsPanel.this.editHandler.setSelectionValue(modelValue, (Boolean)value);
                    break;
                }
                case 2: {
                    modelValue.setValue(((Double)value).doubleValue());
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Double.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "vary";
                }
                case 1: {
                    return "strength name";
                }
                case 2: {
                    return "value";
                }
                case 3: {
                    return "comment";
                }
            }
            return null;
        }

        @Override
        public boolean isValueSetEnabled() {
            return this.isMultipleRowSetEnabled();
        }

        @Override
        public void setValueAllSelected(Double value) {
            this.setValueSelectedRows(value, 2);
        }

        @Override
        public void checkAllSelected() {
            this.setValueSelectedRows(true, 0);
        }

        @Override
        public boolean isCheckUncheckEnabled() {
            return this.isMultipleRowSetEnabled();
        }

        @Override
        public void uncheckAllSelected() {
            this.setValueSelectedRows(false, 0);
        }

        @Override
        public String getValueName() {
            return "strength value";
        }

        @Override
        public List<Action> getActions() {
            if (AbstractKnobsPanel.this.getActionProvider() != null) {
                return AbstractKnobsPanel.this.getActionProvider().getActions();
            }
            return new ArrayList<Action>();
        }
    }
}

