/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.dialog;

import cern.accsoft.steering.jmad.model.JMadModel;
import cern.accsoft.steering.jmad.model.JMadModelStartupConfiguration;
import cern.accsoft.steering.jmad.modeldefs.domain.JMadModelDefinition;
import cern.accsoft.steering.jmad.modeldefs.io.impl.ModelDefinitionUtil;
import cern.accsoft.steering.jmad.service.JMadService;
import com.google.common.base.Strings;
import java.awt.Frame;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.jmad.modelpack.gui.conf.JMadModelSelectionDialogFactory;
import org.jmad.modelpack.gui.domain.JMadModelSelection;
import org.jmad.modelpack.gui.domain.JMadModelSelectionType;
import org.jmad.modelpack.service.JMadModelPackageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMadOptionPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMadOptionPane.class);
    private static final JFileChooser FILECHOOSER = new JFileChooser();

    private JMadOptionPane() {
    }

    public static JMadModel showCreateModelDialog(JMadModelSelectionDialogFactory modelpackDialogFactory, JMadService jmadService) {
        Optional selection = modelpackDialogFactory.showAndWaitModelSelection(JMadModelSelectionType.ALL);
        if (selection.isPresent()) {
            JMadModelDefinition modelDefinition = ((JMadModelSelection)selection.get()).modelDefinition();
            JMadModelStartupConfiguration startupConfiguration = ((JMadModelSelection)selection.get()).startupConfiguration().orElse(null);
            return jmadService.createModel(modelDefinition, startupConfiguration);
        }
        return null;
    }

    public static void showExportModelDefinitionDialog(Frame frame, JMadModelDefinition modelDefinition, JMadService jmadService) {
        FILECHOOSER.setDialogTitle("Exporting model " + modelDefinition.getName());
        int returnValue = FILECHOOSER.showSaveDialog(frame);
        if (returnValue == 0) {
            jmadService.getModelDefinitionExporter().export(modelDefinition, FILECHOOSER.getSelectedFile());
        } else {
            LOGGER.debug("Definition export aborted by user.");
        }
    }

    public static JMadModel showCreateModelFromFileDialog(Frame frame, JMadService jmadService) {
        FILECHOOSER.setDialogTitle("Select model definition file ...");
        int returnValue = FILECHOOSER.showOpenDialog(frame);
        if (returnValue == 0) {
            JMadModelDefinition modelDefinition = jmadService.getModelDefinitionImporter().importModelDefinition(FILECHOOSER.getSelectedFile());
            return jmadService.createModel(modelDefinition);
        }
        LOGGER.debug("Definition import aborted by user.");
        return null;
    }

    public static JMadModel showCreateModelFromUriDialog(Frame frame, JMadModelPackageService modelPackageService) {
        String userUri = JOptionPane.showInputDialog(frame, (Object)"Enter URI to open ...");
        if (Strings.isNullOrEmpty((String)userUri)) {
            LOGGER.debug("URI import aborted by user.");
            return null;
        }
        try {
            URI uri = new URI(userUri);
            return (JMadModel)modelPackageService.createModelFromUri(uri).block();
        }
        catch (Exception e) {
            LOGGER.error("Error opening '{}': {}", new Object[]{userUri, e.getMessage(), e});
            return null;
        }
    }

    static {
        FILECHOOSER.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "JMad Model Definition XML files";
            }

            @Override
            public boolean accept(File f) {
                return ModelDefinitionUtil.isXmlFileName((String)f.getName());
            }
        });
        FILECHOOSER.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "JMad Model Definition ZIP files";
            }

            @Override
            public boolean accept(File f) {
                return ModelDefinitionUtil.isZipFileName((String)f.getName());
            }
        });
        FILECHOOSER.setAcceptAllFileFilterUsed(true);
    }
}

