/*
 * Decompiled with CFR 0.152.
 */
package cern.accsoft.steering.jmad.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutDialog {
    private static final Dimension PREFERRED_SIZE = new Dimension(700, 250);
    private final JDialog dialog;
    private final JPanel contentPane;

    public AboutDialog(JFrame parentFrame) {
        this.dialog = new JDialog(parentFrame);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setPreferredSize(PREFERRED_SIZE);
        this.contentPane = new JPanel(new BorderLayout(10, 10));
        this.dialog.setContentPane(this.contentPane);
    }

    public void setIcon(ImageIcon imageIcon) {
        Objects.requireNonNull(imageIcon);
        this.dialog.setIconImage(imageIcon.getImage());
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(imageIcon);
        iconLabel.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.contentPane.add((Component)iconLabel, "West");
    }

    public void setText(String title, String product, String extra) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<h1>" + title + "</h1>");
        sb.append("<table cellSpacing=0 cellPadding=0 border=0>");
        sb.append("<tr><td><b>Product:&nbsp;</b></td><td>" + product + "</td></tr>");
        sb.append("</table><br>");
        sb.append(extra + "<br>");
        sb.append("</html>");
        JPanel box = new JPanel();
        box.add(new JLabel(sb.toString()));
        this.contentPane.add((Component)box, "Center");
    }

    public void show() {
        this.dialog.pack();
        this.dialog.setVisible(true);
    }
}

